/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import java.util.ArrayList;
import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Function;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.UserDefinedFunction;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.i18n.I18n;

public final class ShowUserDefinedFunctionsCommand
extends ModelShellCommand {
    static final String NAME = "show-user-defined-functions";

    public ShowUserDefinedFunctionsCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        try {
            String[] namePatterns = this.processOptionalArguments(0);
            boolean hasPatterns = namePatterns.length != 0;
            Model model = this.getModel();
            Function[] functions = model.getFunctions(this.getTransaction(), namePatterns);
            if (functions.length == 0) {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)ModelCommandsI18n.noMatchingUserDefinedFunctions, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)ModelCommandsI18n.noUserDefinedFunctions, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                }
            } else {
                ArrayList<Function> udfs = new ArrayList<Function>(functions.length);
                for (Function function : functions) {
                    if (!UserDefinedFunction.RESOLVER.resolvable(this.getTransaction(), (KomodoObject)function)) continue;
                    udfs.add(function);
                }
                if (udfs.isEmpty()) {
                    if (hasPatterns) {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.noMatchingUserDefinedFunctions, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    } else {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.noUserDefinedFunctions, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    }
                } else {
                    if (hasPatterns) {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.matchedUserDefinedFunctionsHeader, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    } else {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.userDefinedFunctionsHeader, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    }
                    int indent = 10;
                    for (Function function : udfs) {
                        this.print(10, I18n.bind((String)WorkspaceCommandsI18n.printRelationalObject, (Object[])new Object[]{function.getName(this.getTransaction()), this.getWorkspaceStatus().getTypeDisplay((KomodoObject)function, null)}), new Object[0]);
                    }
                }
            }
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return -1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showUserDefinedFunctionsHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showUserDefinedFunctionsExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showUserDefinedFunctionsUsage, (Object[])new Object[0]), new Object[0]);
    }
}

