/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import java.util.ArrayList;
import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Procedure;
import org.komodo.relational.model.VirtualProcedure;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.i18n.I18n;

public final class ShowVirtualProceduresCommand
extends ModelShellCommand {
    static final String NAME = "show-virtual-procedures";

    public ShowVirtualProceduresCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        try {
            String[] namePatterns = this.processOptionalArguments(0);
            boolean hasPatterns = namePatterns.length != 0;
            Model model = this.getModel();
            Procedure[] procedures = model.getProcedures(this.getTransaction(), namePatterns);
            if (procedures.length == 0) {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)ModelCommandsI18n.noMatchingVirtualProcedures, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)ModelCommandsI18n.noVirtualProcedures, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                }
            } else {
                ArrayList<Procedure> virtualProcedures = new ArrayList<Procedure>(procedures.length);
                for (Procedure procedure : procedures) {
                    if (!VirtualProcedure.RESOLVER.resolvable(this.getTransaction(), (KomodoObject)procedure)) continue;
                    virtualProcedures.add(procedure);
                }
                if (virtualProcedures.isEmpty()) {
                    if (hasPatterns) {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.noMatchingVirtualProcedures, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    } else {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.noVirtualProcedures, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    }
                } else {
                    if (hasPatterns) {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.matchedVirtualProceduresHeader, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    } else {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.virtualProceduresHeader, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    }
                    int indent = 10;
                    for (Procedure virtProc : virtualProcedures) {
                        this.print(10, I18n.bind((String)WorkspaceCommandsI18n.printRelationalObject, (Object[])new Object[]{virtProc.getName(this.getTransaction()), this.getWorkspaceStatus().getTypeDisplay((KomodoObject)virtProc, null)}), new Object[0]);
                    }
                }
            }
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return -1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showVirtualProceduresHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showVirtualProceduresExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showVirtualProceduresUsage, (Object[])new Object[0]), new Object[0]);
    }
}

