/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.parameter;

import java.util.List;
import org.komodo.relational.RelationalConstants;
import org.komodo.relational.commands.parameter.ParameterCommandsI18n;
import org.komodo.relational.commands.parameter.ParameterShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Parameter;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class SetParameterPropertyCommand
extends ParameterShellCommand {
    static final String NAME = "set-property";

    public SetParameterPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            Parameter parameter = this.getParameter();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "datatypeName": {
                    parameter.setDatatypeName(transaction, value);
                    break;
                }
                case "defaultValue": {
                    parameter.setDefaultValue(transaction, value);
                    break;
                }
                case "parameterType": {
                    if (Parameter.Direction.IN.name().equals(value)) {
                        parameter.setDirection(transaction, Parameter.Direction.IN);
                        break;
                    }
                    if (Parameter.Direction.IN_OUT.name().equals(value)) {
                        parameter.setDirection(transaction, Parameter.Direction.IN_OUT);
                        break;
                    }
                    if (Parameter.Direction.OUT.name().equals(value)) {
                        parameter.setDirection(transaction, Parameter.Direction.OUT);
                        break;
                    }
                    if (Parameter.Direction.VARIADIC.name().equals(value)) {
                        parameter.setDirection(transaction, Parameter.Direction.VARIADIC);
                        break;
                    }
                    errorMsg = I18n.bind((String)ParameterCommandsI18n.invalidDirectionPropertyValue, (Object[])new Object[]{"nullable"});
                    break;
                }
                case "datatypeLength": {
                    try {
                        long length = Long.parseLong(value);
                        parameter.setLength(transaction, length);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"datatypeLength"});
                    }
                    break;
                }
                case "nullable": {
                    if (RelationalConstants.Nullable.NO_NULLS.name().equals(value)) {
                        parameter.setNullable(transaction, RelationalConstants.Nullable.NO_NULLS);
                        break;
                    }
                    if (RelationalConstants.Nullable.NULLABLE.name().equals(value)) {
                        parameter.setNullable(transaction, RelationalConstants.Nullable.NULLABLE);
                        break;
                    }
                    if (RelationalConstants.Nullable.NULLABLE_UNKNOWN.name().equals(value)) {
                        parameter.setNullable(transaction, RelationalConstants.Nullable.NULLABLE_UNKNOWN);
                        break;
                    }
                    errorMsg = I18n.bind((String)ParameterCommandsI18n.invalidNullablePropertyValue, (Object[])new Object[]{"nullable"});
                    break;
                }
                case "datatypePrecision": {
                    try {
                        long precision = Long.parseLong(value);
                        parameter.setPrecision(transaction, precision);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"datatypePrecision"});
                    }
                    break;
                }
                case "result": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        parameter.setResult(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"result"});
                    break;
                }
                case "datatypeScale": {
                    try {
                        long scale = Long.parseLong(value);
                        parameter.setScale(transaction, scale);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"datatypeScale"});
                    }
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Parameter.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.setPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ParameterCommandsI18n.setParameterPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ParameterCommandsI18n.setParameterPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ParameterCommandsI18n.setParameterPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        if (args.size() == 1) {
            String theArg = (String)this.getArguments().get(0);
            if ("result".equals(theArg)) {
                this.updateCandidatesForBooleanProperty(lastArgument, candidates);
            } else if ("nullable".equals(theArg)) {
                candidates.add(RelationalConstants.Nullable.NO_NULLS.name());
                candidates.add(RelationalConstants.Nullable.NULLABLE.name());
                candidates.add(RelationalConstants.Nullable.NULLABLE_UNKNOWN.name());
            } else if ("parameterType".equals(theArg)) {
                candidates.add(Parameter.Direction.IN.name());
                candidates.add(Parameter.Direction.IN_OUT.name());
                candidates.add(Parameter.Direction.OUT.name());
                candidates.add(Parameter.Direction.VARIADIC.name());
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

