/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.permission;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.permission.PermissionCommandsI18n;
import org.komodo.relational.commands.permission.PermissionShellCommand;
import org.komodo.relational.vdb.Condition;
import org.komodo.relational.vdb.Permission;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddConditionCommand
extends PermissionShellCommand {
    static final String NAME = "add-condition";

    public AddConditionCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String conditionName = this.requiredArgument(0, I18n.bind((String)PermissionCommandsI18n.missingConditionName, (Object[])new Object[0]));
            Permission permission = this.getPermission();
            Condition[] existingConditions = permission.getConditions(this.getTransaction(), new String[]{conditionName});
            if (existingConditions.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{conditionName, Condition.class.getSimpleName()}), null);
            }
            permission.addCondition(this.getTransaction(), conditionName);
            result = new CommandResultImpl(I18n.bind((String)PermissionCommandsI18n.conditionAdded, (Object[])new Object[]{conditionName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.addConditionHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.addConditionExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.addConditionUsage, (Object[])new Object[0]), new Object[0]);
    }
}

