/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.permission;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.permission.PermissionCommandsI18n;
import org.komodo.relational.commands.permission.PermissionShellCommand;
import org.komodo.relational.vdb.Mask;
import org.komodo.relational.vdb.Permission;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddMaskCommand
extends PermissionShellCommand {
    static final String NAME = "add-mask";

    public AddMaskCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String maskName = this.requiredArgument(0, I18n.bind((String)PermissionCommandsI18n.missingMaskName, (Object[])new Object[0]));
            Permission permission = this.getPermission();
            Mask[] existingMasks = permission.getMasks(this.getTransaction(), new String[]{maskName});
            if (existingMasks.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{maskName, Mask.class.getSimpleName()}), null);
            }
            permission.addMask(this.getTransaction(), maskName);
            result = new CommandResultImpl(I18n.bind((String)PermissionCommandsI18n.maskAdded, (Object[])new Object[]{maskName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.addMaskHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.addMaskExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.addMaskUsage, (Object[])new Object[0]), new Object[0]);
    }
}

