/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.permission;

import java.util.ArrayList;
import java.util.List;
import org.komodo.relational.commands.permission.PermissionCommandsI18n;
import org.komodo.relational.commands.permission.PermissionShellCommand;
import org.komodo.relational.vdb.Condition;
import org.komodo.relational.vdb.Permission;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class DeleteConditionCommand
extends PermissionShellCommand {
    static final String NAME = "delete-condition";

    public DeleteConditionCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String conditionName = this.requiredArgument(0, I18n.bind((String)PermissionCommandsI18n.missingConditionName, (Object[])new Object[0]));
            Permission permission = this.getPermission();
            permission.removeCondition(this.getTransaction(), conditionName);
            result = new CommandResultImpl(I18n.bind((String)PermissionCommandsI18n.conditionDeleted, (Object[])new Object[]{conditionName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.deleteConditionHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.deleteConditionExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.deleteConditionUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        Permission permission = this.getPermission();
        Condition[] conditions = permission.getConditions(uow, new String[0]);
        ArrayList<String> existingConditionNames = new ArrayList<String>(conditions.length);
        for (Condition condition : conditions) {
            existingConditionNames.add(condition.getName(uow));
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingConditionNames);
            } else {
                for (String item : existingConditionNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

