/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.permission;

import java.util.List;
import org.komodo.relational.commands.permission.PermissionCommandsI18n;
import org.komodo.relational.commands.permission.PermissionShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.vdb.Permission;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class SetPermissionPropertyCommand
extends PermissionShellCommand {
    static final String NAME = "set-property";

    public SetPermissionPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            Permission permission = this.getPermission();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            if ("allowAlter".equals(name)) {
                if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                    permission.setAllowAlter(transaction, Boolean.parseBoolean(value));
                } else {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"allowAlter"});
                }
            } else if ("allowCreate".equals(name)) {
                if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                    permission.setAllowCreate(transaction, Boolean.parseBoolean(value));
                } else {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"allowCreate"});
                }
            } else if ("allowDelete".equals(name)) {
                if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                    permission.setAllowDelete(transaction, Boolean.parseBoolean(value));
                } else {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"allowDelete"});
                }
            } else if ("allowExecute".equals(name)) {
                if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                    permission.setAllowExecute(transaction, Boolean.parseBoolean(value));
                } else {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"allowExecute"});
                }
            } else if ("allowLanguage".equals(name)) {
                if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                    permission.setAllowLanguage(transaction, Boolean.parseBoolean(value));
                } else {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"allowLanguage"});
                }
            } else if ("allowRead".equals(name)) {
                if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                    permission.setAllowRead(transaction, Boolean.parseBoolean(value));
                } else {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"allowRead"});
                }
            } else if ("allowUpdate".equals(name)) {
                if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                    permission.setAllowUpdate(transaction, Boolean.parseBoolean(value));
                } else {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"allowUpdate"});
                }
            } else {
                errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Permission.class.getSimpleName()});
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.setPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.setPermissionPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.setPermissionPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.setPermissionPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        String theArg;
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        if (args.size() == 1 && ("allowAlter".equals(theArg = (String)this.getArguments().get(0)) || "allowCreate".equals(theArg) || "allowDelete".equals(theArg) || "allowExecute".equals(theArg) || "allowLanguage".equals(theArg) || "allowRead".equals(theArg) || "allowUpdate".equals(theArg))) {
            this.updateCandidatesForBooleanProperty(lastArgument, candidates);
        }
        return TabCompletionModifier.AUTO;
    }
}

