/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.permission;

import org.komodo.relational.commands.permission.PermissionCommandsI18n;
import org.komodo.relational.commands.permission.PermissionShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.vdb.Condition;
import org.komodo.relational.vdb.Permission;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.i18n.I18n;

public final class ShowConditionsCommand
extends PermissionShellCommand {
    static final String NAME = "show-conditions";

    public ShowConditionsCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        try {
            String[] namePatterns = this.processOptionalArguments(0);
            boolean hasPatterns = namePatterns.length != 0;
            Permission permission = this.getPermission();
            Condition[] conditions = permission.getConditions(this.getTransaction(), namePatterns);
            if (conditions.length == 0) {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)PermissionCommandsI18n.noMatchedConditions, (Object[])new Object[]{permission.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)PermissionCommandsI18n.noConditions, (Object[])new Object[]{permission.getName(this.getTransaction())}), new Object[0]);
                }
            } else {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)PermissionCommandsI18n.matchedConditionsHeader, (Object[])new Object[]{permission.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)PermissionCommandsI18n.conditionsHeader, (Object[])new Object[]{permission.getName(this.getTransaction())}), new Object[0]);
                }
                int indent = 10;
                for (Condition condition : conditions) {
                    this.print(10, I18n.bind((String)WorkspaceCommandsI18n.printRelationalObject, (Object[])new Object[]{condition.getName(this.getTransaction()), this.getWorkspaceStatus().getTypeDisplay((KomodoObject)condition, null)}), new Object[0]);
                }
            }
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return -1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.showConditionsHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.showConditionsExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.showConditionsUsage, (Object[])new Object[0]), new Object[0]);
    }
}

