/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.permission;

import org.komodo.relational.commands.permission.PermissionCommandsI18n;
import org.komodo.relational.commands.permission.PermissionShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.vdb.Mask;
import org.komodo.relational.vdb.Permission;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.i18n.I18n;

public final class ShowMasksCommand
extends PermissionShellCommand {
    static final String NAME = "show-masks";

    public ShowMasksCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        try {
            String[] namePatterns = this.processOptionalArguments(0);
            boolean hasPatterns = namePatterns.length != 0;
            Permission permission = this.getPermission();
            Mask[] masks = permission.getMasks(this.getTransaction(), namePatterns);
            if (masks.length == 0) {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)PermissionCommandsI18n.noMatchedMasks, (Object[])new Object[]{permission.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)PermissionCommandsI18n.noMasks, (Object[])new Object[]{permission.getName(this.getTransaction())}), new Object[0]);
                }
            } else {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)PermissionCommandsI18n.matchedMasksHeader, (Object[])new Object[]{permission.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)PermissionCommandsI18n.masksHeader, (Object[])new Object[]{permission.getName(this.getTransaction())}), new Object[0]);
                }
                int indent = 10;
                for (Mask mask : masks) {
                    this.print(10, I18n.bind((String)WorkspaceCommandsI18n.printRelationalObject, (Object[])new Object[]{mask.getName(this.getTransaction()), this.getWorkspaceStatus().getTypeDisplay((KomodoObject)mask, null)}), new Object[0]);
                }
            }
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return -1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.showMasksHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.showMasksExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)PermissionCommandsI18n.showMasksUsage, (Object[])new Object[0]), new Object[0]);
    }
}

