/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.pushdownfunction;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.pushdownfunction.PushdownFunctionCommandsI18n;
import org.komodo.relational.commands.pushdownfunction.PushdownFunctionShellCommand;
import org.komodo.relational.model.Parameter;
import org.komodo.relational.model.PushdownFunction;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddParameterCommand
extends PushdownFunctionShellCommand {
    static final String NAME = "add-parameter";

    public AddParameterCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String paramName = this.requiredArgument(0, I18n.bind((String)PushdownFunctionCommandsI18n.missingParameterName, (Object[])new Object[0]));
            PushdownFunction func = this.getPushdownFunction();
            Parameter[] params = func.getParameters(this.getTransaction(), new String[]{paramName});
            if (params.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{paramName, Parameter.class.getSimpleName()}), null);
            }
            func.addParameter(this.getTransaction(), paramName);
            result = new CommandResultImpl(I18n.bind((String)PushdownFunctionCommandsI18n.parameterAdded, (Object[])new Object[]{paramName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)PushdownFunctionCommandsI18n.addParameterHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)PushdownFunctionCommandsI18n.addParameterExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)PushdownFunctionCommandsI18n.addParameterUsage, (Object[])new Object[0]), new Object[0]);
    }
}

