/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.pushdownfunction;

import java.util.ArrayList;
import java.util.List;
import org.komodo.relational.commands.pushdownfunction.PushdownFunctionCommandsI18n;
import org.komodo.relational.commands.pushdownfunction.PushdownFunctionShellCommand;
import org.komodo.relational.model.Parameter;
import org.komodo.relational.model.PushdownFunction;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class DeleteParameterCommand
extends PushdownFunctionShellCommand {
    static final String NAME = "delete-parameter";

    public DeleteParameterCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String paramName = this.requiredArgument(0, I18n.bind((String)PushdownFunctionCommandsI18n.missingParameterName, (Object[])new Object[0]));
            PushdownFunction func = this.getPushdownFunction();
            func.removeParameter(this.getTransaction(), paramName);
            result = new CommandResultImpl(I18n.bind((String)PushdownFunctionCommandsI18n.parameterDeleted, (Object[])new Object[]{paramName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)PushdownFunctionCommandsI18n.deleteParameterHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)PushdownFunctionCommandsI18n.deleteParameterExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)PushdownFunctionCommandsI18n.deleteParameterUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        PushdownFunction func = this.getPushdownFunction();
        Parameter[] parameters = func.getParameters(uow, new String[0]);
        ArrayList<String> existingParamNames = new ArrayList<String>(parameters.length);
        for (Parameter parameter : parameters) {
            existingParamNames.add(parameter.getName(uow));
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingParamNames);
            } else {
                for (String item : existingParamNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

