/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.pushdownfunction;

import java.util.Arrays;
import java.util.List;
import org.komodo.relational.commands.pushdownfunction.PushdownFunctionCommandsI18n;
import org.komodo.relational.commands.pushdownfunction.PushdownFunctionShellCommand;
import org.komodo.relational.model.DataTypeResultSet;
import org.komodo.relational.model.PushdownFunction;
import org.komodo.relational.model.TabularResultSet;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class SetResultSetCommand
extends PushdownFunctionShellCommand {
    static final String NAME = "set-result-set";
    protected static final List<String> ALL_TYPES = Arrays.asList(DataTypeResultSet.class.getSimpleName(), TabularResultSet.class.getSimpleName());

    public SetResultSetCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String rsType = this.requiredArgument(0, I18n.bind((String)PushdownFunctionCommandsI18n.missingResultSetType, (Object[])new Object[0]));
            PushdownFunction func = this.getPushdownFunction();
            if (rsType.equals(DataTypeResultSet.class.getSimpleName())) {
                func.setResultSet(this.getTransaction(), DataTypeResultSet.class);
            } else if (rsType.equals(TabularResultSet.class.getSimpleName())) {
                func.setResultSet(this.getTransaction(), TabularResultSet.class);
            } else {
                new CommandResultImpl(false, I18n.bind((String)PushdownFunctionCommandsI18n.invalidResultSetType, (Object[])new Object[]{rsType}), null);
            }
            result = new CommandResultImpl(I18n.bind((String)PushdownFunctionCommandsI18n.resultSetTypeSet, (Object[])new Object[]{rsType}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)PushdownFunctionCommandsI18n.setResultSetHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)PushdownFunctionCommandsI18n.setResultSetExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)PushdownFunctionCommandsI18n.setResultSetUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_TYPES);
            } else {
                for (String item : ALL_TYPES) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

