/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.pushdownfunction;

import java.util.List;
import org.komodo.relational.commands.pushdownfunction.PushdownFunctionCommandsI18n;
import org.komodo.relational.commands.pushdownfunction.PushdownFunctionShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Function;
import org.komodo.relational.model.PushdownFunction;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class UnsetPushdownFunctionPropertyCommand
extends PushdownFunctionShellCommand {
    static final String NAME = "unset-property";

    public UnsetPushdownFunctionPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.unsetMissingPropertyName, (Object[])new Object[0]));
            PushdownFunction func = this.getPushdownFunction();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "AGGREGATE": {
                    func.setAggregate(transaction, false);
                    break;
                }
                case "ALLOWS_DISTINCT": {
                    func.setAllowsDistinct(transaction, false);
                    break;
                }
                case "ALLOWS_ORDERBY": {
                    func.setAllowsOrderBy(transaction, false);
                    break;
                }
                case "ANALYTIC": {
                    func.setAnalytic(transaction, false);
                    break;
                }
                case "DECOMPOSABLE": {
                    func.setDecomposable(transaction, false);
                    break;
                }
                case "ANNOTATION": {
                    func.setDescription(this.getTransaction(), null);
                    break;
                }
                case "DETERMINISM": {
                    func.setDeterminism(transaction, Function.Determinism.DEFAULT_VALUE);
                    break;
                }
                case "NAMEINSOURCE": {
                    func.setNameInSource(this.getTransaction(), null);
                    break;
                }
                case "NULL_ON_NULL": {
                    func.setNullOnNull(transaction, false);
                    break;
                }
                case "schemaElementType": {
                    func.setSchemaElementType(transaction, null);
                    break;
                }
                case "UPDATECOUNT": {
                    func.setUpdateCount(transaction, 0L);
                    break;
                }
                case "USES_DISTINCT_ROWS": {
                    func.setUsesDistinctRows(transaction, false);
                    break;
                }
                case "UUID": {
                    func.setUuid(this.getTransaction(), null);
                    break;
                }
                case "VARARGS": {
                    func.setVarArgs(transaction, false);
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, PushdownFunction.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.unsetPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)PushdownFunctionCommandsI18n.unsetPushdownFunctionPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)PushdownFunctionCommandsI18n.unsetPushdownFunctionPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)PushdownFunctionCommandsI18n.unsetPushdownFunctionPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

