/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.resultsetcolumn;

import java.util.List;
import org.komodo.relational.RelationalConstants;
import org.komodo.relational.commands.resultsetcolumn.ResultSetColumnCommandsI18n;
import org.komodo.relational.commands.resultsetcolumn.ResultSetColumnShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.ResultSetColumn;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class SetResultSetColumnPropertyCommand
extends ResultSetColumnShellCommand {
    static final String NAME = "set-property";

    public SetResultSetColumnPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            ResultSetColumn column = this.getResultSetColumn();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "datatypeName": {
                    column.setDatatypeName(transaction, value);
                    break;
                }
                case "defaultValue": {
                    column.setDefaultValue(transaction, value);
                    break;
                }
                case "ANNOTATION": {
                    column.setDescription(transaction, value);
                    break;
                }
                case "datatypeLength": {
                    try {
                        long length = Long.parseLong(value);
                        column.setLength(transaction, length);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"datatypeLength"});
                    }
                    break;
                }
                case "NAMEINSOURCE": {
                    column.setNameInSource(transaction, value);
                    break;
                }
                case "nullable": {
                    if (RelationalConstants.Nullable.NO_NULLS.name().equals(value)) {
                        column.setNullable(transaction, RelationalConstants.Nullable.NO_NULLS);
                        break;
                    }
                    if (RelationalConstants.Nullable.NULLABLE.name().equals(value)) {
                        column.setNullable(transaction, RelationalConstants.Nullable.NULLABLE);
                        break;
                    }
                    if (RelationalConstants.Nullable.NULLABLE_UNKNOWN.name().equals(value)) {
                        column.setNullable(transaction, RelationalConstants.Nullable.NULLABLE_UNKNOWN);
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidNullablePropertyValue, (Object[])new Object[]{"nullable"});
                    break;
                }
                case "datatypePrecision": {
                    try {
                        long precision = Long.parseLong(value);
                        column.setPrecision(transaction, precision);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"datatypePrecision"});
                    }
                    break;
                }
                case "datatypeScale": {
                    try {
                        long scale = Long.parseLong(value);
                        column.setScale(transaction, scale);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"datatypeScale"});
                    }
                    break;
                }
                case "UUID": {
                    column.setUuid(transaction, value);
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Column.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.setPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ResultSetColumnCommandsI18n.setResultSetColumnPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ResultSetColumnCommandsI18n.setResultSetColumnPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ResultSetColumnCommandsI18n.setResultSetColumnPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        String theArg;
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        if (args.size() == 1 && "nullable".equals(theArg = (String)this.getArguments().get(0))) {
            candidates.add(RelationalConstants.Nullable.NO_NULLS.name());
            candidates.add(RelationalConstants.Nullable.NULLABLE.name());
            candidates.add(RelationalConstants.Nullable.NULLABLE_UNKNOWN.name());
        }
        return TabCompletionModifier.AUTO;
    }
}

