/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.resultsetcolumn;

import java.util.List;
import org.komodo.relational.commands.resultsetcolumn.ResultSetColumnCommandsI18n;
import org.komodo.relational.commands.resultsetcolumn.ResultSetColumnShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.ResultSetColumn;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class UnsetResultSetColumnPropertyCommand
extends ResultSetColumnShellCommand {
    static final String NAME = "unset-property";

    public UnsetResultSetColumnPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.unsetMissingPropertyName, (Object[])new Object[0]));
            ResultSetColumn column = this.getResultSetColumn();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "datatypeName": {
                    column.setDatatypeName(transaction, null);
                    break;
                }
                case "defaultValue": {
                    column.setDefaultValue(transaction, null);
                    break;
                }
                case "ANNOTATION": {
                    column.setDescription(transaction, null);
                    break;
                }
                case "datatypeLength": {
                    column.setLength(transaction, 0L);
                    break;
                }
                case "NAMEINSOURCE": {
                    column.setNameInSource(transaction, null);
                    break;
                }
                case "nullable": {
                    column.setNullable(transaction, null);
                    break;
                }
                case "datatypePrecision": {
                    column.setPrecision(transaction, 0L);
                    break;
                }
                case "datatypeScale": {
                    column.setScale(transaction, 0L);
                    break;
                }
                case "UUID": {
                    column.setUuid(transaction, null);
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Column.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.unsetPropertySuccess, (Object[])new Object[]{column.getName(transaction), name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ResultSetColumnCommandsI18n.unsetResultSetColumnPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ResultSetColumnCommandsI18n.unsetResultSetColumnPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ResultSetColumnCommandsI18n.unsetResultSetColumnPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

