/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerConnectCommand;
import org.komodo.relational.commands.server.ServerDatasourceCommand;
import org.komodo.relational.commands.server.ServerDatasourceTypeCommand;
import org.komodo.relational.commands.server.ServerDatasourceTypesCommand;
import org.komodo.relational.commands.server.ServerDatasourcesCommand;
import org.komodo.relational.commands.server.ServerDeployDatasourceCommand;
import org.komodo.relational.commands.server.ServerDeployDriverCommand;
import org.komodo.relational.commands.server.ServerDeployVdbCommand;
import org.komodo.relational.commands.server.ServerDisconnectCommand;
import org.komodo.relational.commands.server.ServerGetDatasourceCommand;
import org.komodo.relational.commands.server.ServerGetVdbCommand;
import org.komodo.relational.commands.server.ServerSetPropertyCommand;
import org.komodo.relational.commands.server.ServerShowPropertiesCommand;
import org.komodo.relational.commands.server.ServerTranslatorCommand;
import org.komodo.relational.commands.server.ServerTranslatorsCommand;
import org.komodo.relational.commands.server.ServerUndeployDatasourceCommand;
import org.komodo.relational.commands.server.ServerUndeployVdbCommand;
import org.komodo.relational.commands.server.ServerUnsetPropertyCommand;
import org.komodo.relational.commands.server.ServerVdbCommand;
import org.komodo.relational.commands.server.ServerVdbsCommand;
import org.komodo.relational.commands.server.WkspStatusServerManager;
import org.komodo.relational.teiid.Teiid;
import org.komodo.relational.workspace.ServerManager;
import org.komodo.shell.api.ShellCommand;
import org.komodo.shell.api.ShellCommandProvider;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.runtime.TeiidInstance;
import org.komodo.utils.KLog;
import org.komodo.utils.i18n.I18n;

public class ServerCommandProvider
implements ShellCommandProvider {
    public static final String SERVER_DEFAULT_KEY = "SERVER_DEFAULT";

    public Set<Class<? extends ShellCommand>> provideCommands() {
        HashSet<Class<? extends ShellCommand>> result = new HashSet<Class<? extends ShellCommand>>();
        result.add(ServerConnectCommand.class);
        result.add(ServerDisconnectCommand.class);
        result.add(ServerVdbsCommand.class);
        result.add(ServerTranslatorsCommand.class);
        result.add(ServerDatasourcesCommand.class);
        result.add(ServerDatasourceTypesCommand.class);
        result.add(ServerDeployDatasourceCommand.class);
        result.add(ServerDeployDriverCommand.class);
        result.add(ServerDeployVdbCommand.class);
        result.add(ServerUndeployDatasourceCommand.class);
        result.add(ServerUndeployVdbCommand.class);
        result.add(ServerGetDatasourceCommand.class);
        result.add(ServerGetVdbCommand.class);
        result.add(ServerVdbCommand.class);
        result.add(ServerTranslatorCommand.class);
        result.add(ServerDatasourceCommand.class);
        result.add(ServerDatasourceTypeCommand.class);
        result.add(ServerShowPropertiesCommand.class);
        result.add(ServerSetPropertyCommand.class);
        result.add(ServerUnsetPropertyCommand.class);
        return result;
    }

    public Teiid resolve(Repository.UnitOfWork uow, KomodoObject kObj) throws KException {
        if (Teiid.RESOLVER.resolvable(uow, kObj)) {
            return (Teiid)Teiid.RESOLVER.resolve(uow, kObj);
        }
        return null;
    }

    public String getStatusMessage(WorkspaceStatus wsStatus) throws KException {
        TeiidInstance teiidInstance = WkspStatusServerManager.getInstance(wsStatus).getDefaultTeiidInstance();
        String teiidUrl = teiidInstance.getUrl();
        boolean isConnected = WkspStatusServerManager.getInstance(wsStatus).isDefaultServerConnected();
        String teiidConnected = isConnected ? I18n.bind((String)ServerCommandsI18n.connected, (Object[])new Object[0]) : I18n.bind((String)ServerCommandsI18n.notConnected, (Object[])new Object[0]);
        String currentServerText = I18n.bind((String)ServerCommandsI18n.serverStatusText, (Object[])new Object[]{teiidUrl, teiidConnected});
        return I18n.bind((String)ServerCommandsI18n.currentServer, (Object[])new Object[]{currentServerText});
    }

    public void initWorkspaceState(WorkspaceStatus wsStatus) {
        boolean connectOnStartup;
        Properties providedGlobalProps = wsStatus.getProvidedGlobalProperties();
        if (!providedGlobalProps.containsKey(ServerManager.SERVER_CONNECT_ON_STARTUP)) {
            wsStatus.setProvidedGlobalProperty(ServerManager.SERVER_CONNECT_ON_STARTUP, Boolean.toString(true), Boolean.class.getName());
        }
        if (connectOnStartup = Boolean.parseBoolean(wsStatus.getProvidedGlobalProperties().getProperty(ServerManager.SERVER_CONNECT_ON_STARTUP))) {
            try {
                WkspStatusServerManager.getInstance(wsStatus).connectDefaultServer();
            }
            catch (Exception ex) {
                KLog.getLogger().error(I18n.bind((String)ServerCommandsI18n.errorConnectingToServerOnStartup, (Object[])new Object[0]), new Object[0]);
            }
        }
    }
}

