/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class ServerConnectCommand
extends ServerShellCommand {
    static final String NAME = "server-connect";

    public ServerConnectCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String serverName = this.getWorkspaceServerName();
            this.print(5, I18n.bind((String)ServerCommandsI18n.attemptingToConnect, (Object[])new Object[]{serverName}), new Object[0]);
            try {
                boolean connected = this.connectWorkspaceServer();
                String connectStatus = connected ? I18n.bind((String)ServerCommandsI18n.connected, (Object[])new Object[0]) : I18n.bind((String)ServerCommandsI18n.notConnected, (Object[])new Object[0]);
                this.getWorkspaceStatus().updateAvailableCommands();
                result = new CommandResultImpl(I18n.bind((String)ServerCommandsI18n.teiidStatus, (Object[])new Object[]{serverName, connectStatus}));
            }
            catch (Exception ex) {
                result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.connectionError, (Object[])new Object[0]), ex);
            }
        }
        catch (Exception e) {
            result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.connectionError, (Object[])new Object[0]), e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 0;
    }

    @Override
    public final boolean isValidForCurrentContext() {
        return !this.hasConnectedWorkspaceServer();
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverConnectHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverConnectExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverConnectUsage, (Object[])new Object[0]), new Object[0]);
    }
}

