/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.util.Collections;
import java.util.List;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerObjPrintUtils;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.relational.commands.server.ServerUtils;
import org.komodo.relational.commands.server.WkspStatusServerManager;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.utils.i18n.I18n;

public final class ServerDatasourceCommand
extends ServerShellCommand {
    static final String NAME = "server-datasource";

    public ServerDatasourceCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String sourceName = this.requiredArgument(0, I18n.bind((String)ServerCommandsI18n.missingDatasourceName, (Object[])new Object[0]));
            CommandResult validationResult = this.validateHasConnectedWorkspaceServer();
            if (!validationResult.isOk()) {
                return validationResult;
            }
            TeiidDataSource source = null;
            try {
                List<String> existingSourceNames = ServerUtils.getDatasourceNames(this.getWorkspaceTeiidInstance());
                if (!existingSourceNames.contains(sourceName)) {
                    return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverDatasourceNotFound, (Object[])new Object[]{sourceName}), null);
                }
                source = this.getWorkspaceTeiidInstance().getDataSource(sourceName);
            }
            catch (Exception ex) {
                result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.connectionErrorWillDisconnect, (Object[])new Object[0]), ex);
                WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).disconnectDefaultServer();
                return result;
            }
            if (source == null) {
                return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverDatasourceNotFound, (Object[])new Object[]{sourceName}), null);
            }
            String title = I18n.bind((String)ServerCommandsI18n.infoMessageDatasource, (Object[])new Object[]{sourceName, this.getWorkspaceServerName()});
            this.print(5, title, new Object[0]);
            ServerObjPrintUtils.printDatasourceDetails(this.getWriter(), 5, source);
            result = CommandResult.SUCCESS;
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDatasourceHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDatasourceExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDatasourceUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        try {
            List<String> existingSourceNames = ServerUtils.getDatasourceNames(this.getWorkspaceTeiidInstance());
            Collections.sort(existingSourceNames);
            if (args.isEmpty()) {
                if (lastArgument == null) {
                    candidates.addAll(existingSourceNames);
                } else {
                    for (String item : existingSourceNames) {
                        if (!item.startsWith(lastArgument)) continue;
                        candidates.add(item);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.print();
            this.print(5, I18n.bind((String)ServerCommandsI18n.connectionErrorWillDisconnect, (Object[])new Object[0]), new Object[0]);
            WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).disconnectDefaultServer();
        }
        return TabCompletionModifier.AUTO;
    }
}

