/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.komodo.relational.RelationalObject;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerObjPrintUtils;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.relational.commands.server.WkspStatusServerManager;
import org.komodo.relational.teiid.Teiid;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class ServerDatasourceTypeCommand
extends ServerShellCommand {
    static final String NAME = "server-datasource-type";

    public ServerDatasourceTypeCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String sourceTypeName = this.requiredArgument(0, I18n.bind((String)ServerCommandsI18n.missingDatasourceTypeName, (Object[])new Object[0]));
            CommandResult validationResult = this.validateHasConnectedWorkspaceServer();
            if (!validationResult.isOk()) {
                return validationResult;
            }
            Collection propDefns = null;
            try {
                Set typeNames = this.getWorkspaceTeiidInstance().getDataSourceTypeNames();
                if (!typeNames.contains(sourceTypeName)) {
                    return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverDatasourceTypeNotFound, (Object[])new Object[]{sourceTypeName}), null);
                }
                propDefns = this.getWorkspaceTeiidInstance().getTemplatePropertyDefns(sourceTypeName);
            }
            catch (Exception ex) {
                result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.connectionErrorWillDisconnect, (Object[])new Object[0]), ex);
                WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).disconnectDefaultServer();
                return result;
            }
            if (propDefns == null) {
                return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverDatasourceTypeNotFound, (Object[])new Object[]{sourceTypeName}), null);
            }
            String title = I18n.bind((String)ServerCommandsI18n.infoMessageDatasourceType, (Object[])new Object[]{sourceTypeName, this.getWorkspaceServerName()});
            this.print(5, title, new Object[0]);
            this.print(5, I18n.bind((String)ServerCommandsI18n.datasourceTypePropertiesHeader, (Object[])new Object[0]), new Object[0]);
            ServerObjPrintUtils.printDatasourceTemplateProperties(this.getWriter(), 5, propDefns, I18n.bind((String)ServerCommandsI18n.datasourceTypeNameLabel, (Object[])new Object[0]), I18n.bind((String)ServerCommandsI18n.datasourceTypeDefaultValueLabel, (Object[])new Object[0]));
            result = CommandResult.SUCCESS;
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    @Override
    protected RelationalObject get() throws Exception {
        return super.get();
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDatasourceTypeHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDatasourceTypeExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDatasourceTypeUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        try {
            Teiid teiid = this.getWorkspaceServer();
            Set types = teiid.getTeiidInstance(this.getTransaction()).getDataSourceTypeNames();
            ArrayList existingTypes = new ArrayList(types);
            Collections.sort(existingTypes);
            if (args.isEmpty()) {
                if (lastArgument == null) {
                    candidates.addAll(existingTypes);
                } else {
                    for (String item : existingTypes) {
                        if (!item.startsWith(lastArgument)) continue;
                        candidates.add(item);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.print();
            this.print(5, I18n.bind((String)ServerCommandsI18n.connectionErrorWillDisconnect, (Object[])new Object[0]), new Object[0]);
            WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).disconnectDefaultServer();
        }
        return TabCompletionModifier.AUTO;
    }
}

