/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.relational.commands.server.ServerUtils;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.shell.util.PrintUtils;
import org.komodo.spi.KException;
import org.komodo.utils.i18n.I18n;

public final class ServerDatasourcesCommand
extends ServerShellCommand {
    static final String NAME = "server-datasources";

    public ServerDatasourcesCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            CommandResult validationResult = this.validateHasConnectedWorkspaceServer();
            if (!validationResult.isOk()) {
                return validationResult;
            }
            String title = I18n.bind((String)ServerCommandsI18n.infoMessageDatasources, (Object[])new Object[]{this.getWorkspaceServerName()});
            this.print(5, title, new Object[0]);
            List<String> sourceNames = ServerUtils.getDatasourceNames(this.getWorkspaceTeiidInstance());
            if (sourceNames.isEmpty()) {
                this.print(5, I18n.bind((String)ServerCommandsI18n.noDatasourcesMsg, (Object[])new Object[0]), new Object[0]);
            } else {
                Collections.sort(sourceNames);
                PrintUtils.printMultiLineItemList((int)5, (Writer)this.getWriter(), sourceNames, (int)4, null);
            }
            result = CommandResult.SUCCESS;
        }
        catch (Exception e) {
            result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.connectionErrorWillDisconnect, (Object[])new Object[0]), e);
            try {
                this.disconnectWorkspaceServer();
            }
            catch (KException kException) {
                // empty catch block
            }
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 0;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDatasourcesHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDatasourcesExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDatasourcesUsage, (Object[])new Object[0]), new Object[0]);
    }
}

