/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.relational.commands.server.ServerUtils;
import org.komodo.relational.commands.server.WkspStatusServerManager;
import org.komodo.relational.connection.Connection;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.runtime.TeiidInstance;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class ServerDeployDatasourceCommand
extends ServerShellCommand {
    static final String NAME = "server-deploy-datasource";
    private static final List<String> VALID_OVERWRITE_ARGS = Arrays.asList("-o", "--overwrite");

    public ServerDeployDatasourceCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            boolean overwrite;
            String sourceName = this.requiredArgument(0, I18n.bind((String)ServerCommandsI18n.missingDatasourceName, (Object[])new Object[0]));
            String overwriteArg = this.optionalArgument(1, null);
            boolean bl = overwrite = !StringUtils.isBlank((String)overwriteArg);
            if (overwrite && !VALID_OVERWRITE_ARGS.contains(overwriteArg)) {
                return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.overwriteArgInvalid, (Object[])new Object[]{overwriteArg}), null);
            }
            if (!this.getWorkspaceManager(this.getTransaction()).hasChild(this.getTransaction(), sourceName, "dv:connection")) {
                return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.workspaceDatasourceNotFound, (Object[])new Object[]{sourceName}), null);
            }
            CommandResult validationResult = this.validateHasConnectedWorkspaceServer();
            if (!validationResult.isOk()) {
                return validationResult;
            }
            TeiidInstance teiidInstance = this.getWorkspaceTeiidInstance();
            KomodoObject datasourceObj = this.getWorkspaceManager(this.getTransaction()).getChild(this.getTransaction(), sourceName, "dv:connection");
            Connection sourceToDeploy = (Connection)Connection.RESOLVER.resolve(this.getTransaction(), datasourceObj);
            String sourceType = sourceToDeploy.getDriverName(this.getTransaction());
            if (StringUtils.isEmpty((String)sourceType) || !ServerUtils.hasDatasourceType(teiidInstance, sourceType)) {
                return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.datasourceDeploymentTypeNotFound, (Object[])new Object[]{sourceType}), null);
            }
            try {
                boolean serverHasDatasource = teiidInstance.dataSourceExists(sourceName);
                if (serverHasDatasource && !overwrite) {
                    return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.datasourceDeploymentOverwriteDisabled, (Object[])new Object[]{sourceName}), null);
                }
                Properties sourceProps = null;
                try {
                    sourceToDeploy.getPropertiesForServerDeployment(this.getTransaction(), teiidInstance);
                }
                catch (Exception ex) {
                    result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.datasourcePropertiesError, (Object[])new Object[]{ex.getLocalizedMessage()}), null);
                    return result;
                }
                try {
                    if (serverHasDatasource) {
                        teiidInstance.deleteDataSource(sourceName);
                    }
                    teiidInstance.getOrCreateDataSource(sourceName, sourceName, sourceType, sourceProps);
                }
                catch (Exception ex) {
                    result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.datasourceDeploymentError, (Object[])new Object[]{ex.getLocalizedMessage()}), null);
                    return result;
                }
            }
            catch (Exception ex) {
                result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.connectionErrorWillDisconnect, (Object[])new Object[0]), ex);
                WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).disconnectDefaultServer();
                return result;
            }
            this.print(5, I18n.bind((String)ServerCommandsI18n.datasourceDeployFinished, (Object[])new Object[0]), new Object[0]);
            result = CommandResult.SUCCESS;
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDeployDatasourceHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDeployDatasourceExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDeployDatasourceUsage, (Object[])new Object[0]), new Object[0]);
    }

    protected int getMaxArgCount() {
        return 2;
    }

    @Override
    public final boolean isValidForCurrentContext() {
        return this.isWorkspaceContext() && this.hasConnectedWorkspaceServer();
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Connection[] datasources = this.getWorkspaceManager(this.getTransaction()).findConnections(this.getTransaction());
        ArrayList<String> existingDatasourceNames = new ArrayList<String>(datasources.length);
        for (Connection datasource : datasources) {
            existingDatasourceNames.add(datasource.getName(this.getTransaction()));
        }
        Collections.sort(existingDatasourceNames);
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingDatasourceNames);
            } else {
                for (String item : existingDatasourceNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

