/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.io.File;
import java.util.Set;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.relational.commands.server.WkspStatusServerManager;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.runtime.TeiidInstance;
import org.komodo.utils.i18n.I18n;

public final class ServerDeployDriverCommand
extends ServerShellCommand {
    static final String NAME = "server-deploy-driver";

    public ServerDeployDriverCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String driverName = this.requiredArgument(0, I18n.bind((String)ServerCommandsI18n.missingDriverNameForDeployment, (Object[])new Object[0]));
            String fileName = this.requiredArgument(1, I18n.bind((String)ServerCommandsI18n.missingInputDriverFilePath, (Object[])new Object[0]));
            String validationResult = this.validateReadableFileArg(fileName);
            if (!"OK".equals(validationResult)) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.inputFileError, (Object[])new Object[]{fileName, validationResult}), null);
            }
            validationResult = this.validateHasConnectedWorkspaceServer();
            if (!validationResult.isOk()) {
                return validationResult;
            }
            try {
                Set serverTypes = this.getWorkspaceTeiidInstance().getDataSourceTypeNames();
                if (serverTypes.contains(driverName)) {
                    return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.driverDeployErrorServerHasMatch, (Object[])new Object[]{driverName}), null);
                }
                File driverFile = new File(fileName);
                TeiidInstance teiidInstance = this.getWorkspaceTeiidInstance();
                try {
                    teiidInstance.deployDriver(driverName, driverFile);
                }
                catch (Exception ex) {
                    result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.driverDeploymentError, (Object[])new Object[]{ex.getLocalizedMessage()}), null);
                    return result;
                }
            }
            catch (Exception ex) {
                result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.connectionErrorWillDisconnect, (Object[])new Object[0]), ex);
                WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).disconnectDefaultServer();
                return result;
            }
            this.print(5, I18n.bind((String)ServerCommandsI18n.driverDeployFinished, (Object[])new Object[]{driverName}), new Object[0]);
            result = CommandResult.SUCCESS;
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDeployDriverHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDeployDriverExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDeployDriverUsage, (Object[])new Object[0]), new Object[0]);
    }

    protected int getMaxArgCount() {
        return 2;
    }
}

