/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.relational.commands.server.ServerUtils;
import org.komodo.relational.commands.server.WkspStatusServerManager;
import org.komodo.relational.model.Model;
import org.komodo.relational.vdb.ModelSource;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.runtime.TeiidInstance;
import org.komodo.spi.runtime.TeiidVdb;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class ServerDeployVdbCommand
extends ServerShellCommand {
    static final String NAME = "server-deploy-vdb";
    private static final List<String> VALID_OVERWRITE_ARGS = Arrays.asList("-o", "--overwrite");

    public ServerDeployVdbCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            boolean overwrite;
            String vdbName = this.requiredArgument(0, I18n.bind((String)ServerCommandsI18n.missingVdbName, (Object[])new Object[0]));
            String overwriteArg = this.optionalArgument(1, null);
            boolean bl = overwrite = !StringUtils.isBlank((String)overwriteArg);
            if (overwrite && !VALID_OVERWRITE_ARGS.contains(overwriteArg)) {
                return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.overwriteArgInvalid, (Object[])new Object[]{overwriteArg}), null);
            }
            if (!this.getWorkspaceManager(this.getTransaction()).hasChild(this.getTransaction(), vdbName, "vdb:virtualDatabase")) {
                return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.workspaceVdbNotFound, (Object[])new Object[]{vdbName}), null);
            }
            KomodoObject vdbObj = this.getWorkspaceManager(this.getTransaction()).getChild(this.getTransaction(), vdbName, "vdb:virtualDatabase");
            Vdb vdbToDeploy = (Vdb)Vdb.RESOLVER.resolve(this.getTransaction(), vdbObj);
            CommandResult validationResult = this.validateHasConnectedWorkspaceServer();
            if (!validationResult.isOk()) {
                return validationResult;
            }
            TeiidInstance teiidInstance = this.getWorkspaceTeiidInstance();
            try {
                byte[] vdbXml;
                boolean serverHasVdb = this.serverHasVdb(teiidInstance, vdbToDeploy.getName(this.getTransaction()), vdbToDeploy.getVersion(this.getTransaction()));
                if (serverHasVdb && !overwrite) {
                    return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.vdbDeploymentOverwriteDisabled, (Object[])new Object[]{vdbName, vdbToDeploy.getVersion(this.getTransaction())}), null);
                }
                Set<String> sourceJndiNames = this.getPhysicalModelJndis(vdbToDeploy);
                if (!sourceJndiNames.isEmpty()) {
                    List<String> serverJndiNames = ServerUtils.getDatasourceJndiNames(teiidInstance);
                    for (String sourceJndiName : sourceJndiNames) {
                        if (serverJndiNames.contains(sourceJndiName)) continue;
                        return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.vdbDeployFailedMissingSourceJndi, (Object[])new Object[]{sourceJndiName}), null);
                    }
                }
                if ((vdbXml = vdbToDeploy.export(this.getTransaction(), null)) == null || vdbXml.length == 0) {
                    return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.vdbExportFailed, (Object[])new Object[0]), null);
                }
                String vdbToDeployName = vdbToDeploy.getName(this.getTransaction());
                String vdbDeploymentName = vdbToDeployName + "-vdb.xml";
                ByteArrayInputStream stream = new ByteArrayInputStream(vdbXml);
                try {
                    teiidInstance.deployDynamicVdb(vdbDeploymentName, (InputStream)stream);
                }
                catch (Exception ex) {
                    result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.vdbDeploymentError, (Object[])new Object[]{ex.getLocalizedMessage()}), null);
                    return result;
                }
            }
            catch (Exception ex) {
                result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.connectionErrorWillDisconnect, (Object[])new Object[0]), ex);
                WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).disconnectDefaultServer();
                return result;
            }
            this.print(5, I18n.bind((String)ServerCommandsI18n.vdbDeployFinished, (Object[])new Object[0]), new Object[0]);
            result = CommandResult.SUCCESS;
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    private Set<String> getPhysicalModelJndis(Vdb theVdb) throws Exception {
        Model[] models;
        HashSet<String> physicalModelJndis = new HashSet<String>();
        for (Model model : models = theVdb.getModels(this.getTransaction(), new String[0])) {
            ModelSource[] sources;
            Model.Type modelType = model.getModelType(this.getTransaction());
            if (modelType != Model.Type.PHYSICAL) continue;
            for (ModelSource source : sources = model.getSources(this.getTransaction(), new String[0])) {
                String sourceJndiName = source.getJndiName(this.getTransaction());
                if (StringUtils.isEmpty((String)sourceJndiName)) continue;
                physicalModelJndis.add(sourceJndiName);
            }
        }
        return physicalModelJndis;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDeployVdbHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDeployVdbExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDeployVdbUsage, (Object[])new Object[0]), new Object[0]);
    }

    private boolean serverHasVdb(TeiidInstance teiidInstance, String vdbName, int vdbVersion) throws Exception {
        if (!teiidInstance.hasVdb(vdbName)) {
            return false;
        }
        Collection serverVdbs = teiidInstance.getVdbs();
        for (TeiidVdb serverVdb : serverVdbs) {
            if (!serverVdb.getName().equals(vdbName) || !serverVdb.getVersion().equals(vdbVersion)) continue;
            return true;
        }
        return false;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    @Override
    public final boolean isValidForCurrentContext() {
        return this.isWorkspaceContext() && this.hasConnectedWorkspaceServer();
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        WorkspaceManager mgr = this.getWorkspaceManager(this.getTransaction());
        Vdb[] vdbs = mgr.findVdbs(uow);
        ArrayList<String> existingVdbNames = new ArrayList<String>(vdbs.length);
        for (Vdb vdb : vdbs) {
            existingVdbNames.add(vdb.getName(uow));
        }
        Collections.sort(existingVdbNames);
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingVdbNames);
            } else {
                for (String item : existingVdbNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

