/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class ServerDisconnectCommand
extends ServerShellCommand {
    static final String NAME = "server-disconnect";

    public ServerDisconnectCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            if (this.hasConnectedWorkspaceServer()) {
                this.print(5, I18n.bind((String)ServerCommandsI18n.attemptingToDisconnect, (Object[])new Object[]{this.getWorkspaceServerName()}), new Object[0]);
                this.disconnectWorkspaceServer();
                this.getWorkspaceStatus().updateAvailableCommands();
                result = new CommandResultImpl(I18n.bind((String)ServerCommandsI18n.disconnectSuccessMsg, (Object[])new Object[]{this.getWorkspaceServerName()}));
            } else {
                result = new CommandResultImpl(I18n.bind((String)ServerCommandsI18n.noServerToDisconnectMsg, (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.connectionError, (Object[])new Object[0]), e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 0;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDisconnectHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDisconnectExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverDisconnectUsage, (Object[])new Object[0]), new Object[0]);
    }
}

