/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.relational.commands.server.ServerUtils;
import org.komodo.relational.commands.server.WkspStatusServerManager;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.connection.Connection;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class ServerGetDatasourceCommand
extends ServerShellCommand {
    static final String NAME = "server-get-datasource";
    private static final List<String> VALID_OVERWRITE_ARGS = Arrays.asList("-o", "--overwrite");

    public ServerGetDatasourceCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            boolean overwrite;
            String datasourceName = this.requiredArgument(0, I18n.bind((String)ServerCommandsI18n.missingDatasourceName, (Object[])new Object[0]));
            String overwriteArg = this.optionalArgument(1, null);
            boolean bl = overwrite = !StringUtils.isBlank((String)overwriteArg);
            if (overwrite && !VALID_OVERWRITE_ARGS.contains(overwriteArg)) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.overwriteArgInvalid, (Object[])new Object[]{overwriteArg}), null);
            }
            boolean hasDS = this.getWorkspaceManager(this.getTransaction()).hasChild(this.getTransaction(), datasourceName, "dv:connection");
            if (hasDS && !overwrite) {
                return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.datasourceOverwriteNotEnabled, (Object[])new Object[]{datasourceName}), null);
            }
            CommandResult validationResult = this.validateHasConnectedWorkspaceServer();
            if (!validationResult.isOk()) {
                return validationResult;
            }
            TeiidDataSource serverDS = null;
            try {
                List<String> existingSourceNames = ServerUtils.getDatasourceNames(this.getWorkspaceTeiidInstance());
                if (!existingSourceNames.contains(datasourceName)) {
                    return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverDatasourceNotFound, (Object[])new Object[]{datasourceName}), null);
                }
                serverDS = this.getWorkspaceTeiidInstance().getDataSource(datasourceName);
            }
            catch (Exception ex) {
                result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.connectionErrorWillDisconnect, (Object[])new Object[0]), ex);
                WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).disconnectDefaultServer();
                return result;
            }
            if (serverDS == null) {
                return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverDatasourceNotFound, (Object[])new Object[]{datasourceName}), null);
            }
            if (hasDS) {
                KomodoObject datasourceToDelete = this.getWorkspaceManager(this.getTransaction()).getChild(this.getTransaction(), datasourceName, "dv:connection");
                this.getWorkspaceManager(this.getTransaction()).delete(this.getTransaction(), new KomodoObject[]{datasourceToDelete});
            }
            Connection newDatasource = this.getWorkspaceManager(this.getTransaction()).createConnection(this.getTransaction(), null, datasourceName);
            this.setRepoDatasourceProperties(newDatasource, serverDS.getProperties());
            this.print(5, I18n.bind((String)ServerCommandsI18n.datasourceCopyToRepoFinished, (Object[])new Object[0]), new Object[0]);
            result = CommandResult.SUCCESS;
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    @Override
    public final boolean isValidForCurrentContext() {
        return this.isWorkspaceContext() && this.hasConnectedWorkspaceServer();
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverGetDatasourceHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverGetDatasourceExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverGetDatasourceUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        try {
            List<String> existingDatasourceNames = ServerUtils.getDatasourceNames(this.getWorkspaceTeiidInstance());
            Collections.sort(existingDatasourceNames);
            if (args.isEmpty()) {
                if (lastArgument == null) {
                    candidates.addAll(existingDatasourceNames);
                } else {
                    for (String item : existingDatasourceNames) {
                        if (!item.startsWith(lastArgument)) continue;
                        candidates.add(item);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.print();
            this.print(5, I18n.bind((String)ServerCommandsI18n.connectionErrorWillDisconnect, (Object[])new Object[0]), new Object[0]);
            WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).disconnectDefaultServer();
        }
        return TabCompletionModifier.AUTO;
    }

    private void setRepoDatasourceProperties(Connection repoSource, Properties serverDsProperties) throws Exception {
        for (String key : serverDsProperties.stringPropertyNames()) {
            String value = serverDsProperties.getProperty(key);
            if (key.equals("jndi-name")) {
                repoSource.setJndiName(this.getTransaction(), value);
                continue;
            }
            if (key.equals("driver-name")) {
                repoSource.setDriverName(this.getTransaction(), value);
                continue;
            }
            if (key.equals("class-name")) {
                repoSource.setClassName(this.getTransaction(), value);
                repoSource.setJdbc(this.getTransaction(), false);
                continue;
            }
            repoSource.setProperty(this.getTransaction(), key, new Object[]{value});
        }
    }
}

