/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.relational.commands.server.ServerUtils;
import org.komodo.relational.commands.server.WkspStatusServerManager;
import org.komodo.relational.commands.workspace.UploadVdbCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.runtime.TeiidVdb;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class ServerGetVdbCommand
extends ServerShellCommand {
    static final String NAME = "server-get-vdb";
    private static final String TEMPFILE_PREFIX = "Vdb-";
    private static final String TEMPFILE_SUFFIX = ".xml";
    private static final List<String> VALID_OVERWRITE_ARGS = Arrays.asList("-o", "--overwrite");

    public ServerGetVdbCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            boolean overwrite;
            String vdbName = this.requiredArgument(0, I18n.bind((String)ServerCommandsI18n.missingVdbName, (Object[])new Object[0]));
            String overwriteArg = this.optionalArgument(1, null);
            boolean bl = overwrite = !StringUtils.isBlank((String)overwriteArg);
            if (overwrite && !VALID_OVERWRITE_ARGS.contains(overwriteArg)) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.overwriteArgInvalid, (Object[])new Object[]{overwriteArg}), null);
            }
            boolean hasVdb = this.getWorkspaceManager(this.getTransaction()).hasChild(this.getTransaction(), vdbName, "vdb:virtualDatabase");
            if (hasVdb && !overwrite) {
                return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.vdbOverwriteNotEnabled, (Object[])new Object[]{vdbName}), null);
            }
            CommandResult validationResult = this.validateHasConnectedWorkspaceServer();
            if (!validationResult.isOk()) {
                return validationResult;
            }
            List<String> existingVdbNames = ServerUtils.getVdbNames(this.getWorkspaceTeiidInstance());
            if (!existingVdbNames.contains(vdbName)) {
                return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverVdbNotFound, (Object[])new Object[]{vdbName}), null);
            }
            TeiidVdb vdb = null;
            try {
                vdb = this.getWorkspaceTeiidInstance().getVdb(vdbName);
            }
            catch (Exception ex) {
                result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverGetVdbError, (Object[])new Object[]{vdbName, ex.getLocalizedMessage()}), null);
                return result;
            }
            if (vdb == null) {
                return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverVdbNotFound, (Object[])new Object[]{vdbName}), null);
            }
            String vdbStr = vdb.export();
            File tempFile = File.createTempFile(TEMPFILE_PREFIX, TEMPFILE_SUFFIX);
            Files.write(Paths.get(tempFile.getPath(), new String[0]), vdbStr.getBytes(), new OpenOption[0]);
            UploadVdbCommand uploadVdbCommand = new UploadVdbCommand(this.getWorkspaceStatus());
            uploadVdbCommand.setArguments(new Arguments(vdbName + " " + tempFile.getAbsolutePath() + " -o"));
            CommandResult uploadResult = uploadVdbCommand.execute();
            if (!uploadResult.isOk()) {
                return uploadResult;
            }
            this.print(5, I18n.bind((String)ServerCommandsI18n.vdbCopyToRepoFinished, (Object[])new Object[0]), new Object[0]);
            result = CommandResult.SUCCESS;
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    @Override
    public final boolean isValidForCurrentContext() {
        return this.isWorkspaceContext() && this.hasConnectedWorkspaceServer();
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverGetVdbHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverGetVdbExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverGetVdbUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        try {
            List<String> existingVdbNames = ServerUtils.getVdbNames(this.getWorkspaceTeiidInstance());
            Collections.sort(existingVdbNames);
            if (args.isEmpty()) {
                if (lastArgument == null) {
                    candidates.addAll(existingVdbNames);
                } else {
                    for (String item : existingVdbNames) {
                        if (!item.startsWith(lastArgument)) continue;
                        candidates.add(item);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.print();
            this.print(5, I18n.bind((String)ServerCommandsI18n.connectionErrorWillDisconnect, (Object[])new Object[0]), new Object[0]);
            WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).disconnectDefaultServer();
        }
        return TabCompletionModifier.AUTO;
    }
}

