/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.komodo.shell.ShellI18n;
import org.komodo.shell.util.PrintUtils;
import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidPropertyDefinition;
import org.komodo.spi.runtime.TeiidTranslator;
import org.komodo.spi.runtime.TeiidVdb;
import org.komodo.utils.i18n.I18n;

public class ServerObjPrintUtils
implements StringConstants {
    private static final int DEFAULT_WIDTH = 25;
    private static final int MAX_PROPERTY_VALUE_WIDTH = 100;

    public static void printVdbDetails(Writer writer, int indent, TeiidVdb vdb) {
        if (vdb != null) {
            PrintUtils.print((Writer)writer, (int)indent, (String)("Name: " + vdb.getName()), (Object[])new Object[0]);
            PrintUtils.print((Writer)writer, (int)indent, (String)("Version: " + vdb.getVersion()), (Object[])new Object[0]);
            String vdbType = "Dynamic";
            PrintUtils.print((Writer)writer, (int)indent, (String)("Type: " + vdbType), (Object[])new Object[0]);
            String status = vdb.isActive() ? "ACTIVE" : "INACTIVE";
            PrintUtils.print((Writer)writer, (int)indent, (String)("Status: " + status), (Object[])new Object[0]);
            PrintUtils.print((Writer)writer, (int)indent, (String)"", (Object[])new Object[0]);
            Collection modelNames = vdb.getModelNames();
            PrintUtils.printList((Writer)writer, new ArrayList(modelNames), (String)"VDB Models");
            PrintUtils.print((Writer)writer, (int)indent, (String)"", (Object[])new Object[0]);
            PrintUtils.print((Writer)writer, (int)indent, (String)"VDB Properties:", (Object[])new Object[0]);
            Properties vdbProps = vdb.getProperties();
            PrintUtils.printProperties((Writer)writer, (Properties)vdbProps, (String)"Name", (String)"Value");
        }
    }

    public static void printTranslatorDetails(Writer writer, int indent, TeiidTranslator translator) {
        if (translator != null) {
            PrintUtils.print((Writer)writer, (int)indent, (String)("Name: " + translator.getName()), (Object[])new Object[0]);
            String transType = translator.getType();
            if (transType != null) {
                PrintUtils.print((Writer)writer, (int)indent, (String)("Type: " + translator.getType()), (Object[])new Object[0]);
            }
            PrintUtils.print((Writer)writer, (int)indent, (String)"", (Object[])new Object[0]);
            PrintUtils.print((Writer)writer, (int)indent, (String)"Translator Properties:", (Object[])new Object[0]);
            Properties vdbProps = translator.getProperties();
            PrintUtils.printProperties((Writer)writer, (Properties)vdbProps, (String)"Name", (String)"Value");
        }
    }

    public static void printDatasourceDetails(Writer writer, int indent, TeiidDataSource source) {
        if (source != null) {
            PrintUtils.print((Writer)writer, (int)indent, (String)("Name: " + source.getName()), (Object[])new Object[0]);
            PrintUtils.print((Writer)writer, (int)indent, (String)("Type: " + source.getType()), (Object[])new Object[0]);
            PrintUtils.print((Writer)writer, (int)indent, (String)"", (Object[])new Object[0]);
            PrintUtils.print((Writer)writer, (int)indent, (String)"DataSource Properties:", (Object[])new Object[0]);
            Properties vdbProps = source.getProperties();
            PrintUtils.printProperties((Writer)writer, (Properties)vdbProps, (String)"Name", (String)"Value");
        }
    }

    public static void printDatasourceTemplateProperties(Writer writer, int indent, Collection<TeiidPropertyDefinition> propDefns, String nameTitle, String valueTitle) {
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        int maxNameWidth = 25;
        int maxValueWidth = 25;
        for (TeiidPropertyDefinition propDefn : propDefns) {
            String name = propDefn.getDisplayName();
            Object value = propDefn.getDefaultValue();
            if (value == null) {
                value = I18n.bind((String)ShellI18n.noPropertyValue, (Object[])new Object[0]);
            }
            if (maxNameWidth < name.length()) {
                maxNameWidth = name.length();
            }
            if (maxValueWidth < value.toString().length()) {
                maxValueWidth = value.toString().length();
            }
            sorted.put(name, value.toString());
        }
        if (maxValueWidth > 100) {
            maxValueWidth = 100;
        }
        String format = PrintUtils.getFormat((int[])new int[]{maxNameWidth, maxValueWidth});
        PrintUtils.print((Writer)writer, (int)5, (String)String.format(format, nameTitle, valueTitle), (Object[])new Object[0]);
        PrintUtils.print((Writer)writer, (int)5, (String)String.format(format, PrintUtils.getHeaderDelimiter((int)maxNameWidth), PrintUtils.getHeaderDelimiter((int)maxValueWidth)), (Object[])new Object[0]);
        for (Map.Entry entry : sorted.entrySet()) {
            String propName = (String)entry.getKey();
            String propValue = (String)entry.getValue();
            if (propValue.length() <= maxValueWidth) {
                PrintUtils.print((Writer)writer, (int)5, (String)String.format(format, propName, propValue), (Object[])new Object[0]);
                continue;
            }
            PrintUtils.printPropWithLongValue((Writer)writer, (String)format, (String)propName, (String)propValue, null, (int)maxValueWidth);
        }
    }
}

