/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.util.List;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.teiid.Teiid;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class ServerSetPropertyCommand
extends ServerShellCommand {
    static final String NAME = "server-set-property";

    public ServerSetPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    @Override
    public boolean isValidForCurrentContext() {
        return true;
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            Teiid teiid = this.getWorkspaceServer();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            if ("adminUser".equals(name)) {
                teiid.setAdminUser(transaction, value);
            } else if ("adminPswd".equals(name)) {
                teiid.setAdminPassword(transaction, value);
            } else if ("jdbcUser".equals(name)) {
                teiid.setJdbcUsername(transaction, value);
            } else if ("jdbcPswd".equals(name)) {
                teiid.setJdbcPassword(transaction, value);
            } else if ("host".equals(name)) {
                teiid.setHost(transaction, value);
            } else if ("adminPort".equals(name)) {
                try {
                    int adminPort = Integer.parseInt(value);
                    teiid.setAdminPort(transaction, adminPort);
                }
                catch (NumberFormatException e) {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"adminPort"});
                }
            } else if ("jdbcPort".equals(name)) {
                try {
                    int jdbcPort = Integer.parseInt(value);
                    teiid.setJdbcPort(transaction, jdbcPort);
                }
                catch (NumberFormatException e) {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"jdbcPort"});
                }
            } else if ("adminSecure".equals(name)) {
                if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                    teiid.setAdminSecure(transaction, Boolean.parseBoolean(value));
                } else {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"adminSecure"});
                }
            } else if ("jdbcSecure".equals(name)) {
                if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                    teiid.setAdminSecure(transaction, Boolean.parseBoolean(value));
                } else {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"jdbcSecure"});
                }
            } else {
                errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Teiid.class.getSimpleName()});
            }
            if (StringUtils.isBlank(errorMsg)) {
                CommandResult disconnectResult;
                result = new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.setPropertySuccess, (Object[])new Object[]{name}));
                if (this.hasConnectedWorkspaceServer() && !(disconnectResult = this.getCommand("server-disconnect").execute()).isOk()) {
                    return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverDisconnectError, (Object[])new Object[0]), null);
                }
            } else {
                result = new CommandResultImpl(false, errorMsg, null);
            }
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.setServerPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.setServerPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.setServerPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

