/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.util.Arrays;
import java.util.List;
import org.komodo.relational.commands.RelationalShellCommand;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.WkspStatusServerManager;
import org.komodo.relational.teiid.Teiid;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.KException;
import org.komodo.spi.runtime.TeiidInstance;
import org.komodo.utils.KLog;
import org.komodo.utils.i18n.I18n;

abstract class ServerShellCommand
extends RelationalShellCommand {
    protected static final String ADMIN_PORT = "adminPort";
    protected static final String ADMIN_PSWD = "adminPswd";
    protected static final String ADMIN_USER = "adminUser";
    protected static final String ADMIN_SECURE = "adminSecure";
    protected static final String JDBC_PORT = "jdbcPort";
    protected static final String JDBC_PSWD = "jdbcPswd";
    protected static final String JDBC_USER = "jdbcUser";
    protected static final String JDBC_SECURE = "jdbcSecure";
    protected static final String HOST = "host";
    protected static final List<String> ALL_PROPS = Arrays.asList("adminPort", "adminPswd", "adminUser", "adminSecure", "jdbcPort", "jdbcPswd", "jdbcUser", "jdbcSecure", "host");

    protected ServerShellCommand(String name, WorkspaceStatus status) {
        super(status, name);
    }

    public boolean isValidForCurrentContext() {
        return this.hasConnectedWorkspaceServer();
    }

    protected boolean isWorkspaceContext() {
        return this.getWorkspaceStatus().getLabelProvider().isWorkspacePath(this.getContext().getAbsolutePath());
    }

    protected CommandResult validateHasConnectedWorkspaceServer() {
        if (!this.hasConnectedWorkspaceServer()) {
            return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverNotConnected, (Object[])new Object[0]), null);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public String getCategory() {
        return I18n.bind((String)ServerCommandsI18n.commandCategory, (Object[])new Object[0]);
    }

    protected String getWorkspaceServerName() throws KException {
        return WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).getDefaultServer().getName(this.getTransaction());
    }

    protected Teiid getWorkspaceServer() throws KException {
        return WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).getDefaultServer();
    }

    protected TeiidInstance getWorkspaceTeiidInstance() throws KException {
        return WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).getDefaultTeiidInstance();
    }

    protected boolean connectWorkspaceServer() throws KException {
        return WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).connectDefaultServer();
    }

    protected boolean disconnectWorkspaceServer() throws KException {
        return WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).disconnectDefaultServer();
    }

    protected boolean hasConnectedWorkspaceServer() {
        boolean isConnected = false;
        try {
            isConnected = WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).isDefaultServerConnected();
        }
        catch (KException e) {
            KLog.getLogger().error("Error attempting to check default server connection status: " + e.getLocalizedMessage(), new Object[0]);
        }
        return isConnected;
    }
}

