/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.io.Writer;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.relational.teiid.Teiid;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.shell.util.PrintUtils;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.i18n.I18n;

public class ServerShowPropertiesCommand
extends ServerShellCommand {
    public static final String NAME = "server-show-properties";

    public ServerShowPropertiesCommand(WorkspaceStatus wsStatus) {
        super(NAME, wsStatus);
    }

    @Override
    public boolean isValidForCurrentContext() {
        return true;
    }

    protected CommandResult doExecute() {
        WorkspaceStatus wsStatus = this.getWorkspaceStatus();
        try {
            Teiid teiid = this.getWorkspaceServer();
            PrintUtils.printProperties((WorkspaceStatus)wsStatus, (Writer)this.getWriter(), (boolean)wsStatus.isShowingHiddenProperties(), (boolean)wsStatus.isShowingPropertyNamePrefixes(), (KomodoObject)teiid);
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return 0;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverShowPropertiesHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverShowPropertiesExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverShowPropertiesUsage, (Object[])new Object[0]), new Object[0]);
    }
}

