/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.util.Collections;
import java.util.List;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerObjPrintUtils;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.relational.commands.server.ServerUtils;
import org.komodo.relational.commands.server.WkspStatusServerManager;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.runtime.TeiidTranslator;
import org.komodo.utils.i18n.I18n;

public final class ServerTranslatorCommand
extends ServerShellCommand {
    static final String NAME = "server-translator";

    public ServerTranslatorCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String translatorName = this.requiredArgument(0, I18n.bind((String)ServerCommandsI18n.missingTranslatorName, (Object[])new Object[0]));
            CommandResult validationResult = this.validateHasConnectedWorkspaceServer();
            if (!validationResult.isOk()) {
                return validationResult;
            }
            TeiidTranslator translator = null;
            try {
                List<String> existingTranslatorNames = ServerUtils.getTranslatorNames(this.getWorkspaceTeiidInstance());
                if (!existingTranslatorNames.contains(translatorName.toLowerCase())) {
                    return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverTranslatorNotFound, (Object[])new Object[]{translatorName}), null);
                }
                translator = this.getWorkspaceTeiidInstance().getTranslator(translatorName);
            }
            catch (Exception ex) {
                result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.connectionErrorWillDisconnect, (Object[])new Object[0]), ex);
                WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).disconnectDefaultServer();
                return result;
            }
            if (translator == null) {
                return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverTranslatorNotFound, (Object[])new Object[]{translatorName}), null);
            }
            String title = I18n.bind((String)ServerCommandsI18n.infoMessageTranslator, (Object[])new Object[]{translatorName, this.getWorkspaceServerName()});
            this.print(5, title, new Object[0]);
            ServerObjPrintUtils.printTranslatorDetails(this.getWriter(), 5, translator);
            result = CommandResult.SUCCESS;
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverTranslatorHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverTranslatorExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverTranslatorUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        try {
            List<String> existingTranslatorNames = ServerUtils.getTranslatorNames(this.getWorkspaceTeiidInstance());
            Collections.sort(existingTranslatorNames);
            if (args.isEmpty()) {
                if (lastArgument == null) {
                    candidates.addAll(existingTranslatorNames);
                } else {
                    for (String item : existingTranslatorNames) {
                        if (!item.startsWith(lastArgument)) continue;
                        candidates.add(item);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.print();
            this.print(5, I18n.bind((String)ServerCommandsI18n.connectionErrorWillDisconnect, (Object[])new Object[0]), new Object[0]);
            WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).disconnectDefaultServer();
        }
        return TabCompletionModifier.AUTO;
    }
}

