/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.util.List;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.teiid.Teiid;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.runtime.TeiidAdminInfo;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersionProvider;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class ServerUnsetPropertyCommand
extends ServerShellCommand {
    static final String NAME = "server-unset-property";

    public ServerUnsetPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    @Override
    public boolean isValidForCurrentContext() {
        return true;
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.unsetMissingPropertyName, (Object[])new Object[0]));
            Teiid teiid = this.getWorkspaceServer();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            if ("adminUser".equals(name)) {
                teiid.setAdminUser(transaction, "admin");
            } else if ("adminPswd".equals(name)) {
                teiid.setAdminPassword(transaction, "admin");
            } else if ("jdbcUser".equals(name)) {
                teiid.setJdbcUsername(transaction, "user");
            } else if ("jdbcPswd".equals(name)) {
                teiid.setJdbcPassword(transaction, "user");
            } else if ("host".equals(name)) {
                teiid.setHost(transaction, null);
            } else if ("adminPort".equals(name)) {
                TeiidVersion teiidVersion = TeiidVersionProvider.getInstance().getTeiidVersion();
                teiid.setAdminPort(transaction, TeiidAdminInfo.Util.defaultPort((TeiidVersion)teiidVersion));
            } else if ("jdbcPort".equals(name)) {
                teiid.setJdbcPort(transaction, 31000);
            } else {
                errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Teiid.class.getSimpleName()});
            }
            if (StringUtils.isBlank(errorMsg)) {
                CommandResult disconnectResult;
                result = new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.unsetPropertySuccess, (Object[])new Object[]{name}));
                if (this.hasConnectedWorkspaceServer() && !(disconnectResult = this.getCommand("server-disconnect").execute()).isOk()) {
                    return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverDisconnectError, (Object[])new Object[0]), null);
                }
            } else {
                result = new CommandResultImpl(false, errorMsg, null);
            }
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.unsetServerPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.unsetServerPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.unsetServerPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

