/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.komodo.relational.teiid.Teiid;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.KException;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidInstance;
import org.komodo.spi.runtime.TeiidTranslator;
import org.komodo.utils.StringUtils;

public class ServerUtils {
    public static Teiid getWorkspaceTeiidObject(WorkspaceManager wsMgr, WorkspaceStatus wsStatus, String serverName) throws KException {
        Teiid resultTeiid = null;
        Teiid[] teiids = wsMgr.findTeiids(wsStatus.getTransaction());
        if (teiids == null || teiids.length == 0) {
            return resultTeiid;
        }
        for (Teiid theTeiid : teiids) {
            String teiidName = theTeiid.getName(wsStatus.getTransaction());
            if (!serverName.equals(theTeiid.getId(wsStatus.getTransaction())) && !serverName.equals(teiidName)) continue;
            resultTeiid = theTeiid;
            break;
        }
        return resultTeiid;
    }

    public static boolean hasDatasourceType(TeiidInstance teiidInstance, String sourceType) throws Exception {
        assert (teiidInstance != null);
        Set serverTypes = teiidInstance.getDataSourceTypeNames();
        for (String serverType : serverTypes) {
            if (!serverType.equals(sourceType)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getDatasourceNames(TeiidInstance teiidInstance) throws Exception {
        assert (teiidInstance != null);
        Collection sources = teiidInstance.getDataSources();
        if (sources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> existingSourceNames = new ArrayList<String>();
        for (TeiidDataSource source : sources) {
            existingSourceNames.add(source.getName());
        }
        return existingSourceNames;
    }

    public static List<String> getDatasourceDisplayNames(TeiidInstance teiidInstance) throws Exception {
        assert (teiidInstance != null);
        Collection sources = teiidInstance.getDataSources();
        if (sources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> existingSourceNames = new ArrayList<String>();
        for (TeiidDataSource source : sources) {
            existingSourceNames.add(source.getDisplayName());
        }
        return existingSourceNames;
    }

    public static List<String> getDatasourceJndiNames(TeiidInstance teiidInstance) throws Exception {
        assert (teiidInstance != null);
        Collection sources = teiidInstance.getDataSources();
        if (sources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> existingJndiNames = new ArrayList<String>();
        for (TeiidDataSource source : sources) {
            String jndiName = source.getPropertyValue("jndi-name");
            if (StringUtils.isEmpty((String)jndiName)) continue;
            existingJndiNames.add(jndiName);
        }
        return existingJndiNames;
    }

    public static List<String> getVdbNames(TeiidInstance teiidInstance) throws Exception {
        assert (teiidInstance != null);
        Collection vdbNames = teiidInstance.getVdbNames();
        if (vdbNames.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(vdbNames);
    }

    public static List<String> getTranslatorNames(TeiidInstance teiidInstance) throws Exception {
        assert (teiidInstance != null);
        Collection translators = teiidInstance.getTranslators();
        if (translators.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> existingTranslatorNames = new ArrayList<String>();
        for (TeiidTranslator translator : translators) {
            existingTranslatorNames.add(translator.getName());
        }
        return existingTranslatorNames;
    }
}

