/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.util.Collections;
import java.util.List;
import org.komodo.relational.commands.server.ServerCommandsI18n;
import org.komodo.relational.commands.server.ServerObjPrintUtils;
import org.komodo.relational.commands.server.ServerShellCommand;
import org.komodo.relational.commands.server.ServerUtils;
import org.komodo.relational.commands.server.WkspStatusServerManager;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.runtime.TeiidVdb;
import org.komodo.utils.i18n.I18n;

public final class ServerVdbCommand
extends ServerShellCommand {
    static final String NAME = "server-vdb";

    public ServerVdbCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String vdbName = this.requiredArgument(0, I18n.bind((String)ServerCommandsI18n.missingVdbName, (Object[])new Object[0]));
            CommandResult validationResult = this.validateHasConnectedWorkspaceServer();
            if (!validationResult.isOk()) {
                return validationResult;
            }
            TeiidVdb vdb = null;
            try {
                List<String> existingVdbNames = ServerUtils.getVdbNames(this.getWorkspaceTeiidInstance());
                if (!existingVdbNames.contains(vdbName)) {
                    return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverVdbNotFound, (Object[])new Object[]{vdbName}), null);
                }
                vdb = this.getWorkspaceTeiidInstance().getVdb(vdbName);
            }
            catch (Exception ex) {
                result = new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverGetVdbError, (Object[])new Object[]{vdbName, ex.getLocalizedMessage()}), null);
                return result;
            }
            if (vdb == null) {
                return new CommandResultImpl(false, I18n.bind((String)ServerCommandsI18n.serverVdbNotFound, (Object[])new Object[]{vdbName}), null);
            }
            String title = I18n.bind((String)ServerCommandsI18n.infoMessageVdb, (Object[])new Object[]{vdbName, this.getWorkspaceServerName()});
            this.print(5, title, new Object[0]);
            ServerObjPrintUtils.printVdbDetails(this.getWriter(), 5, vdb);
            result = CommandResult.SUCCESS;
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverVdbHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverVdbExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ServerCommandsI18n.serverVdbUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        try {
            List<String> existingVdbNames = ServerUtils.getVdbNames(this.getWorkspaceTeiidInstance());
            Collections.sort(existingVdbNames);
            if (args.isEmpty()) {
                if (lastArgument == null) {
                    candidates.addAll(existingVdbNames);
                } else {
                    for (String item : existingVdbNames) {
                        if (!item.startsWith(lastArgument)) continue;
                        candidates.add(item);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.print();
            this.print(5, I18n.bind((String)ServerCommandsI18n.connectionErrorWillDisconnect, (Object[])new Object[0]), new Object[0]);
            WkspStatusServerManager.getInstance(this.getWorkspaceStatus()).disconnectDefaultServer();
        }
        return TabCompletionModifier.AUTO;
    }
}

