/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import org.komodo.relational.teiid.Teiid;
import org.komodo.relational.workspace.ServerManager;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.KException;
import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.runtime.TeiidInstance;
import org.komodo.utils.ArgCheck;

public class WkspStatusServerManager
implements StringConstants {
    private static WkspStatusServerManager instance;
    private UpdateCallback wsUpdateCallback = new UpdateCallback();
    private WorkspaceStatus wsStatus;
    private ServerManager serverManager;

    public static WkspStatusServerManager getInstance(WorkspaceStatus wsStatus) throws KException {
        if (instance == null) {
            instance = new WkspStatusServerManager(wsStatus);
        }
        return instance;
    }

    public static void reset() throws KException {
        if (instance == null) {
            return;
        }
        Repository repository = WkspStatusServerManager.instance.wsStatus.getCurrentContext().getRepository();
        ServerManager.uncacheInstance((Repository)repository);
        instance = null;
    }

    private WkspStatusServerManager(WorkspaceStatus wsStatus) throws KException {
        ArgCheck.isNotNull((Object)wsStatus, (String)"wsStatus");
        this.wsStatus = wsStatus;
        this.serverManager = ServerManager.getInstance((Repository)wsStatus.getCurrentContext().getRepository());
    }

    public Teiid getDefaultServer() throws KException {
        return this.serverManager.getDefaultServer(this.wsStatus.getTransaction());
    }

    public boolean connectDefaultServer() throws KException {
        return this.serverManager.connectDefaultServer(this.wsStatus.getTransaction(), (ServerManager.ServerCallback)this.wsUpdateCallback);
    }

    public boolean disconnectDefaultServer() throws KException {
        return this.serverManager.disconnectDefaultServer(this.wsStatus.getTransaction(), (ServerManager.ServerCallback)this.wsUpdateCallback);
    }

    public boolean isDefaultServerConnected() throws KException {
        return this.serverManager.isDefaultServerConnected(this.wsStatus.getTransaction());
    }

    public TeiidInstance getDefaultTeiidInstance() throws KException {
        return this.serverManager.getDefaultTeiidInstance(this.wsStatus.getTransaction());
    }

    private class UpdateCallback
    implements ServerManager.ServerCallback {
        private UpdateCallback() {
        }

        public void execute() {
            WkspStatusServerManager.this.wsStatus.updateAvailableCommands();
        }
    }
}

