/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.storedprocedure;

import java.util.List;
import org.komodo.relational.commands.storedprocedure.StoredProcedureCommandsI18n;
import org.komodo.relational.commands.storedprocedure.StoredProcedureShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.SchemaElement;
import org.komodo.relational.model.StoredProcedure;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class SetStoredProcedurePropertyCommand
extends StoredProcedureShellCommand {
    static final String NAME = "set-property";

    public SetStoredProcedurePropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            StoredProcedure proc = this.getStoredProcedure();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "ANNOTATION": {
                    proc.setDescription(this.getTransaction(), value);
                    break;
                }
                case "NAMEINSOURCE": {
                    proc.setNameInSource(this.getTransaction(), value);
                    break;
                }
                case "NATIVE_QUERY": {
                    proc.setNativeQuery(transaction, value);
                    break;
                }
                case "NON_PREPARED": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        proc.setNonPrepared(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"NON_PREPARED"});
                    break;
                }
                case "schemaElementType": {
                    if (SchemaElement.SchemaElementType.FOREIGN.name().equals(value)) {
                        proc.setSchemaElementType(transaction, SchemaElement.SchemaElementType.FOREIGN);
                        break;
                    }
                    if (SchemaElement.SchemaElementType.VIRTUAL.name().equals(value)) {
                        proc.setSchemaElementType(transaction, SchemaElement.SchemaElementType.VIRTUAL);
                        break;
                    }
                    errorMsg = I18n.bind((String)StoredProcedureCommandsI18n.invalidSchemaElementTypePropertyValue, (Object[])new Object[]{value});
                    break;
                }
                case "UPDATECOUNT": {
                    try {
                        long count = Long.parseLong(value);
                        proc.setUpdateCount(transaction, count);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"UPDATECOUNT"});
                    }
                    break;
                }
                case "UUID": {
                    proc.setUuid(this.getTransaction(), value);
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, StoredProcedure.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.setPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)StoredProcedureCommandsI18n.setStoredProcedurePropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)StoredProcedureCommandsI18n.setStoredProcedurePropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)StoredProcedureCommandsI18n.setStoredProcedurePropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        if (args.size() == 1) {
            String theArg = (String)this.getArguments().get(0);
            if ("NON_PREPARED".equals(theArg)) {
                this.updateCandidatesForBooleanProperty(lastArgument, candidates);
            } else if ("schemaElementType".equals(theArg)) {
                candidates.add(SchemaElement.SchemaElementType.FOREIGN.name());
                candidates.add(SchemaElement.SchemaElementType.VIRTUAL.name());
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

