/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.table.TableCommandsI18n;
import org.komodo.relational.commands.table.TableShellCommand;
import org.komodo.relational.model.AccessPattern;
import org.komodo.relational.model.Table;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddAccessPatternCommand
extends TableShellCommand {
    static final String NAME = "add-access-pattern";

    public AddAccessPatternCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String apName = this.requiredArgument(0, I18n.bind((String)TableCommandsI18n.missingAccessPatternName, (Object[])new Object[0]));
            Table table = this.getTable();
            AccessPattern[] aps = table.getAccessPatterns(this.getTransaction(), new String[]{apName});
            if (aps.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{apName, AccessPattern.class.getSimpleName()}), null);
            }
            table.addAccessPattern(this.getTransaction(), apName);
            result = new CommandResultImpl(I18n.bind((String)TableCommandsI18n.accessPatternAdded, (Object[])new Object[]{apName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addAccessPatternHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addAccessPatternExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addAccessPatternUsage, (Object[])new Object[0]), new Object[0]);
    }
}

