/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.table.TableCommandsI18n;
import org.komodo.relational.commands.table.TableShellCommand;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.Table;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddColumnCommand
extends TableShellCommand {
    static final String NAME = "add-column";

    public AddColumnCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String columnName = this.requiredArgument(0, I18n.bind((String)TableCommandsI18n.missingColumnName, (Object[])new Object[0]));
            Table table = this.getTable();
            Column[] cols = table.getColumns(this.getTransaction(), new String[]{columnName});
            if (cols.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{columnName, Column.class.getSimpleName()}), null);
            }
            table.addColumn(this.getTransaction(), columnName);
            result = new CommandResultImpl(I18n.bind((String)TableCommandsI18n.columnAdded, (Object[])new Object[]{columnName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addColumnHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addColumnExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addColumnUsage, (Object[])new Object[0]), new Object[0]);
    }
}

