/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import org.komodo.relational.commands.table.TableCommandsI18n;
import org.komodo.relational.commands.table.TableShellCommand;
import org.komodo.relational.model.Table;
import org.komodo.repository.ObjectImpl;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class AddForeignKeyCommand
extends TableShellCommand {
    static final String NAME = "add-foreign-key";

    public AddForeignKeyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String fkName = this.requiredArgument(0, I18n.bind((String)TableCommandsI18n.missingForeignKeyName, (Object[])new Object[0]));
            String tableRefPath = this.requiredArgument(1, I18n.bind((String)TableCommandsI18n.missingForeignKeyTableRefPath, (Object[])new Object[0]));
            Table referencedTable = null;
            String repoPath = this.getWorkspaceStatus().getCurrentContextLabelProvider().getPath(this.getTransaction(), tableRefPath);
            if (StringUtils.isBlank((String)repoPath)) {
                repoPath = tableRefPath;
            }
            ObjectImpl possible = new ObjectImpl(this.getRepository(), repoPath, 0);
            try {
                if (Table.RESOLVER.resolvable(this.getTransaction(), (KomodoObject)possible)) {
                    referencedTable = (Table)Table.RESOLVER.resolve(this.getTransaction(), (KomodoObject)possible);
                } else {
                    result = new CommandResultImpl(false, I18n.bind((String)TableCommandsI18n.invalidTablePath, (Object[])new Object[]{tableRefPath}), null);
                }
            }
            catch (Exception e) {
                result = new CommandResultImpl(false, I18n.bind((String)TableCommandsI18n.invalidTablePath, (Object[])new Object[]{tableRefPath}), null);
            }
            if (referencedTable != null) {
                Table table = this.getTable();
                table.addForeignKey(this.getTransaction(), fkName, referencedTable);
                result = new CommandResultImpl(I18n.bind((String)TableCommandsI18n.foreignKeyAdded, (Object[])new Object[]{fkName}));
            }
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addForeignKeyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addForeignKeyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addForeignKeyUsage, (Object[])new Object[0]), new Object[0]);
    }
}

