/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.table.TableCommandsI18n;
import org.komodo.relational.commands.table.TableShellCommand;
import org.komodo.relational.model.Index;
import org.komodo.relational.model.Table;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddIndexCommand
extends TableShellCommand {
    static final String NAME = "add-index";

    public AddIndexCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String indexName = this.requiredArgument(0, I18n.bind((String)TableCommandsI18n.missingIndexName, (Object[])new Object[0]));
            Table table = this.getTable();
            Index[] indxs = table.getIndexes(this.getTransaction(), new String[]{indexName});
            if (indxs.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{indexName, Index.class.getSimpleName()}), null);
            }
            table.addIndex(this.getTransaction(), indexName);
            result = new CommandResultImpl(I18n.bind((String)TableCommandsI18n.indexAdded, (Object[])new Object[]{indexName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addIndexHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addIndexExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addIndexUsage, (Object[])new Object[0]), new Object[0]);
    }
}

