/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import org.komodo.relational.commands.table.TableCommandsI18n;
import org.komodo.relational.commands.table.TableShellCommand;
import org.komodo.relational.model.Table;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddPrimaryKeyCommand
extends TableShellCommand {
    static final String NAME = "add-primary-key";

    public AddPrimaryKeyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String pkName = this.requiredArgument(0, I18n.bind((String)TableCommandsI18n.missingPrimaryKeyName, (Object[])new Object[0]));
            Table table = this.getTable();
            if (table.getPrimaryKey(this.getTransaction()) != null) {
                return new CommandResultImpl(I18n.bind((String)TableCommandsI18n.pkExistsCantAdd, (Object[])new Object[]{pkName}));
            }
            table.setPrimaryKey(this.getTransaction(), pkName);
            result = new CommandResultImpl(I18n.bind((String)TableCommandsI18n.primaryKeyAdded, (Object[])new Object[]{pkName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addPrimaryKeyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addPrimaryKeyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.addPrimaryKeyUsage, (Object[])new Object[0]), new Object[0]);
    }
}

