/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import java.util.ArrayList;
import java.util.List;
import org.komodo.relational.commands.table.TableCommandsI18n;
import org.komodo.relational.commands.table.TableShellCommand;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.Table;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class DeleteColumnCommand
extends TableShellCommand {
    static final String NAME = "delete-column";

    public DeleteColumnCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String columnName = this.requiredArgument(0, I18n.bind((String)TableCommandsI18n.missingColumnName, (Object[])new Object[0]));
            Table table = this.getTable();
            table.removeColumn(this.getTransaction(), columnName);
            result = new CommandResultImpl(I18n.bind((String)TableCommandsI18n.columnDeleted, (Object[])new Object[]{columnName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.deleteColumnHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.deleteColumnExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.deleteColumnUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        Table table = this.getTable();
        Column[] columns = table.getColumns(uow, new String[0]);
        ArrayList<String> existingColumnNames = new ArrayList<String>(columns.length);
        for (Column column : columns) {
            existingColumnNames.add(column.getName(uow));
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingColumnNames);
            } else {
                for (String item : existingColumnNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

