/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import java.util.List;
import org.komodo.relational.commands.table.TableCommandsI18n;
import org.komodo.relational.commands.table.TableShellCommand;
import org.komodo.relational.model.PrimaryKey;
import org.komodo.relational.model.Table;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class DeletePrimaryKeyCommand
extends TableShellCommand {
    static final String NAME = "delete-primary-key";

    public DeletePrimaryKeyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            Table table = this.getTable();
            if (table.getPrimaryKey(this.getTransaction()) == null) {
                return new CommandResultImpl(I18n.bind((String)TableCommandsI18n.noPkToRemove, (Object[])new Object[0]));
            }
            table.removePrimaryKey(this.getTransaction());
            result = new CommandResultImpl(I18n.bind((String)TableCommandsI18n.primaryKeyDeleted, (Object[])new Object[0]));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 0;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.deletePrimaryKeyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.deletePrimaryKeyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.deletePrimaryKeyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        Table table = this.getTable();
        PrimaryKey pk = table.getPrimaryKey(uow);
        if (pk == null) {
            return TabCompletionModifier.NO_AUTOCOMPLETION;
        }
        String pkName = pk.getName(uow);
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.add(pkName);
            } else if (pkName.startsWith(lastArgument)) {
                candidates.add(pkName);
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

