/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import java.util.ArrayList;
import java.util.List;
import org.komodo.relational.commands.table.TableCommandsI18n;
import org.komodo.relational.commands.table.TableShellCommand;
import org.komodo.relational.model.Table;
import org.komodo.relational.model.UniqueConstraint;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class DeleteUniqueConstraintCommand
extends TableShellCommand {
    static final String NAME = "delete-unique-constraint";

    public DeleteUniqueConstraintCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String ucName = this.requiredArgument(0, I18n.bind((String)TableCommandsI18n.missingUniqueConstraintName, (Object[])new Object[0]));
            Table table = this.getTable();
            table.removeUniqueConstraint(this.getTransaction(), ucName);
            result = new CommandResultImpl(I18n.bind((String)TableCommandsI18n.uniqueConstraintDeleted, (Object[])new Object[]{ucName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.deleteUniqueConstraintHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.deleteUniqueConstraintExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.deleteUniqueConstraintUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        Table table = this.getTable();
        UniqueConstraint[] ucs = table.getUniqueConstraints(uow, new String[0]);
        ArrayList<String> existingUCNames = new ArrayList<String>(ucs.length);
        for (UniqueConstraint uc : ucs) {
            existingUCNames.add(uc.getName(uow));
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingUCNames);
            } else {
                for (String item : existingUCNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

