/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import java.util.List;
import org.komodo.relational.commands.table.TableCommandsI18n;
import org.komodo.relational.commands.table.TableShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.SchemaElement;
import org.komodo.relational.model.Table;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class SetTablePropertyCommand
extends TableShellCommand {
    static final String NAME = "set-property";

    public SetTablePropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            Table table = this.getTable();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "ANNOTATION": {
                    table.setDescription(transaction, value);
                    break;
                }
                case "CARDINALITY": {
                    try {
                        int cardinality = Integer.parseInt(value);
                        table.setCardinality(transaction, (long)cardinality);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"CARDINALITY"});
                    }
                    break;
                }
                case "MATERIALIZED": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        table.setMaterialized(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"MATERIALIZED"});
                    break;
                }
                case "MATERIALIZED_TABLE": {
                    table.setMaterializedTable(transaction, value);
                    break;
                }
                case "NAMEINSOURCE": {
                    table.setNameInSource(transaction, value);
                    break;
                }
                case "UPDATABLE": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        table.setUpdatable(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"UPDATABLE"});
                    break;
                }
                case "UUID": {
                    table.setUuid(transaction, value);
                    break;
                }
                case "onCommitValue": {
                    if (Table.OnCommit.DELETE_ROWS.name().equals(value)) {
                        table.setOnCommitValue(transaction, Table.OnCommit.DELETE_ROWS);
                        break;
                    }
                    if (Table.OnCommit.PRESERVE_ROWS.name().equals(value)) {
                        table.setOnCommitValue(transaction, Table.OnCommit.PRESERVE_ROWS);
                        break;
                    }
                    errorMsg = I18n.bind((String)TableCommandsI18n.invalidOnCommitPropertyValue, (Object[])new Object[]{"onCommitValue"});
                    break;
                }
                case "queryExpression": {
                    table.setQueryExpression(transaction, value);
                    break;
                }
                case "schemaElementType": {
                    if (SchemaElement.SchemaElementType.FOREIGN.name().equals(value)) {
                        table.setSchemaElementType(transaction, SchemaElement.SchemaElementType.FOREIGN);
                        break;
                    }
                    if (SchemaElement.SchemaElementType.VIRTUAL.name().equals(value)) {
                        table.setSchemaElementType(transaction, SchemaElement.SchemaElementType.VIRTUAL);
                        break;
                    }
                    errorMsg = I18n.bind((String)TableCommandsI18n.invalidSchemaElementTypePropertyValue, (Object[])new Object[]{value});
                    break;
                }
                case "temporary": {
                    if (Table.TemporaryType.GLOBAL.name().equals(value)) {
                        table.setTemporaryTableType(transaction, Table.TemporaryType.GLOBAL);
                        break;
                    }
                    if (Table.TemporaryType.LOCAL.name().equals(value)) {
                        table.setTemporaryTableType(transaction, Table.TemporaryType.LOCAL);
                        break;
                    }
                    errorMsg = I18n.bind((String)TableCommandsI18n.invalidTemporaryTableTypePropertyValue, (Object[])new Object[]{value});
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Table.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.setPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.setTablePropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.setTablePropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.setTablePropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        if (args.size() == 1) {
            String theArg = (String)this.getArguments().get(0);
            if ("MATERIALIZED".equals(theArg) || "UPDATABLE".equals(theArg)) {
                this.updateCandidatesForBooleanProperty(lastArgument, candidates);
            } else if ("onCommitValue".equals(theArg)) {
                candidates.add(Table.OnCommit.DELETE_ROWS.name());
                candidates.add(Table.OnCommit.PRESERVE_ROWS.name());
            } else if ("schemaElementType".equals(theArg)) {
                candidates.add(SchemaElement.SchemaElementType.FOREIGN.name());
                candidates.add(SchemaElement.SchemaElementType.VIRTUAL.name());
            } else if ("temporary".equals(theArg)) {
                candidates.add(Table.TemporaryType.GLOBAL.name());
                candidates.add(Table.TemporaryType.LOCAL.name());
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

