/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import org.komodo.relational.commands.table.TableCommandsI18n;
import org.komodo.relational.commands.table.TableShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.Table;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.i18n.I18n;

public final class ShowColumnsCommand
extends TableShellCommand {
    static final String NAME = "show-columns";

    public ShowColumnsCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        try {
            String[] namePatterns = this.processOptionalArguments(0);
            boolean hasPatterns = namePatterns.length != 0;
            Table table = this.getTable();
            Column[] columns = table.getColumns(this.getTransaction(), namePatterns);
            if (columns.length == 0) {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)TableCommandsI18n.noMatchingColumns, (Object[])new Object[]{table.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)TableCommandsI18n.noColumns, (Object[])new Object[]{table.getName(this.getTransaction())}), new Object[0]);
                }
            } else {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)TableCommandsI18n.matchingColumnsHeader, (Object[])new Object[]{table.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)TableCommandsI18n.columnsHeader, (Object[])new Object[]{table.getName(this.getTransaction())}), new Object[0]);
                }
                int indent = 10;
                for (Column column : columns) {
                    this.print(10, I18n.bind((String)WorkspaceCommandsI18n.printRelationalObject, (Object[])new Object[]{column.getName(this.getTransaction()), this.getWorkspaceStatus().getTypeDisplay((KomodoObject)column, null)}), new Object[0]);
                }
            }
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return -1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.showColumnsHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.showColumnsExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.showColumnsUsage, (Object[])new Object[0]), new Object[0]);
    }
}

