/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import org.komodo.relational.commands.table.TableCommandsI18n;
import org.komodo.relational.commands.table.TableShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Table;
import org.komodo.relational.model.UniqueConstraint;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.i18n.I18n;

public final class ShowUniqueConstraintsCommand
extends TableShellCommand {
    static final String NAME = "show-unique-constraints";

    public ShowUniqueConstraintsCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        try {
            String[] namePatterns = this.processOptionalArguments(0);
            boolean hasPatterns = namePatterns.length != 0;
            Table table = this.getTable();
            UniqueConstraint[] constraints = table.getUniqueConstraints(this.getTransaction(), namePatterns);
            if (constraints.length == 0) {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)TableCommandsI18n.noMatchingUniqueConstraints, (Object[])new Object[]{table.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)TableCommandsI18n.noUniqueConstraints, (Object[])new Object[]{table.getName(this.getTransaction())}), new Object[0]);
                }
            } else {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)TableCommandsI18n.matchingUniqueConstraintsHeader, (Object[])new Object[]{table.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)TableCommandsI18n.uniqueConstraintsHeader, (Object[])new Object[]{table.getName(this.getTransaction())}), new Object[0]);
                }
                int indent = 10;
                for (UniqueConstraint constraint : constraints) {
                    this.print(10, I18n.bind((String)WorkspaceCommandsI18n.printRelationalObject, (Object[])new Object[]{constraint.getName(this.getTransaction()), this.getWorkspaceStatus().getTypeDisplay((KomodoObject)constraint, null)}), new Object[0]);
                }
            }
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return -1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.showUniqueConstraintsHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.showUniqueConstraintsExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TableCommandsI18n.showUniqueConstraintsUsage, (Object[])new Object[0]), new Object[0]);
    }
}

