/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.tableconstraint;

import java.util.Arrays;
import java.util.List;
import org.komodo.relational.commands.tableconstraint.TableConstraintCommandsI18n;
import org.komodo.relational.commands.tableconstraint.TableConstraintShellCommand;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.Table;
import org.komodo.relational.model.TableConstraint;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.ui.KomodoObjectLabelProvider;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class AddConstraintColumnCommand
extends TableConstraintShellCommand {
    static final String NAME = "add-column";

    public AddConstraintColumnCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String columnPath = this.requiredArgument(0, I18n.bind((String)TableConstraintCommandsI18n.missingColumnPathForAdd, (Object[])new Object[0]));
            String validationMsg = this.validatePath(columnPath);
            if (!validationMsg.equals("OK")) {
                return new CommandResultImpl(false, validationMsg, null);
            }
            KomodoObject possible = this.getWorkspaceStatus().getContextForDisplayPath(columnPath.trim());
            Column column = null;
            try {
                if (Column.RESOLVER.resolvable(this.getTransaction(), possible)) {
                    column = (Column)Column.RESOLVER.resolve(this.getTransaction(), possible);
                } else {
                    result = new CommandResultImpl(false, I18n.bind((String)TableConstraintCommandsI18n.invalidColumnPath, (Object[])new Object[]{columnPath}), null);
                }
            }
            catch (Exception e) {
                result = new CommandResultImpl(false, I18n.bind((String)TableConstraintCommandsI18n.invalidColumnPath, (Object[])new Object[]{columnPath}), null);
            }
            if (column != null) {
                TableConstraint constraint = this.getTableConstraint();
                KomodoObject parentTable = constraint.getParent(this.getTransaction());
                if (parentTable.equals(column.getParent(this.getTransaction()))) {
                    constraint.addColumn(this.getTransaction(), column);
                    result = new CommandResultImpl(I18n.bind((String)TableConstraintCommandsI18n.columnRefAdded, (Object[])new Object[]{columnPath, this.getWorkspaceStatus().getCurrentContextDisplayPath(null)}));
                } else {
                    result = new CommandResultImpl(false, I18n.bind((String)TableConstraintCommandsI18n.invalidColumn, (Object[])new Object[]{this.getWorkspaceStatus().getDisplayPath((KomodoObject)column, null), constraint.getName(this.getTransaction())}), null);
                }
            }
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TableConstraintCommandsI18n.addConstraintColumnHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TableConstraintCommandsI18n.addConstraintColumnExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TableConstraintCommandsI18n.addConstraintColumnUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        if (this.getArguments().isEmpty()) {
            Repository.UnitOfWork uow = this.getTransaction();
            Table parent = this.getTableConstraint().getTable(uow);
            Column[] columns = parent.getColumns(uow, new String[0]);
            if (columns.length == 0) {
                return TabCompletionModifier.AUTO;
            }
            KomodoObjectLabelProvider labelProvider = this.getWorkspaceStatus().getObjectLabelProvider((KomodoObject)columns[0]);
            for (Column column : Arrays.asList(columns)) {
                String absolutePath = column.getAbsolutePath();
                String displayPath = labelProvider.getDisplayPath(this.getTransaction(), (KomodoObject)column, null);
                if (!StringUtils.isBlank((String)lastArgument) && !absolutePath.startsWith(lastArgument) && !displayPath.startsWith(lastArgument)) continue;
                candidates.add(displayPath);
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

