/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.tableconstraint;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.komodo.relational.commands.tableconstraint.TableConstraintCommandsI18n;
import org.komodo.relational.commands.tableconstraint.TableConstraintShellCommand;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.TableConstraint;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.ui.KomodoObjectLabelProvider;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class DeleteConstraintColumnCommand
extends TableConstraintShellCommand {
    static final String NAME = "delete-column";

    public DeleteConstraintColumnCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String columnPathArg = this.requiredArgument(0, I18n.bind((String)TableConstraintCommandsI18n.missingColumnPathForDelete, (Object[])new Object[0]));
            String validationMsg = this.validatePath(columnPathArg);
            if (!validationMsg.equals("OK")) {
                return new CommandResultImpl(false, validationMsg, null);
            }
            KomodoObject possible = this.getWorkspaceStatus().getContextForDisplayPath(columnPathArg.trim());
            Column column = null;
            try {
                if (Column.RESOLVER.resolvable(this.getTransaction(), possible)) {
                    column = (Column)Column.RESOLVER.resolve(this.getTransaction(), possible);
                } else {
                    result = new CommandResultImpl(false, I18n.bind((String)TableConstraintCommandsI18n.invalidColumnPath, (Object[])new Object[]{columnPathArg}), null);
                }
            }
            catch (Exception e) {
                result = new CommandResultImpl(false, I18n.bind((String)TableConstraintCommandsI18n.invalidColumnPath, (Object[])new Object[]{columnPathArg}), null);
            }
            if (column != null) {
                TableConstraint constraint = this.getTableConstraint();
                constraint.removeColumn(this.getTransaction(), column);
                result = new CommandResultImpl(I18n.bind((String)TableConstraintCommandsI18n.columnRemoved, (Object[])new Object[]{columnPathArg, this.getContext().getAbsolutePath()}));
            }
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TableConstraintCommandsI18n.deleteConstraintColumnHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TableConstraintCommandsI18n.deleteConstraintColumnExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TableConstraintCommandsI18n.deleteConstraintColumnUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        if (this.getArguments().isEmpty()) {
            TableConstraint constraint = this.getTableConstraint();
            Column[] refCols = constraint.getColumns(this.getTransaction());
            if (refCols.length == 0) {
                return TabCompletionModifier.AUTO;
            }
            boolean noLastArg = StringUtils.isBlank((String)lastArgument);
            if (refCols.length != 0) {
                KomodoObjectLabelProvider provider = this.getWorkspaceStatus().getObjectLabelProvider((KomodoObject)refCols[0]);
                for (Column column : refCols) {
                    String displayPath = provider.getDisplayPath(this.getTransaction(), (KomodoObject)column, null);
                    String absolutePath = column.getAbsolutePath();
                    if (!noLastArg && !displayPath.startsWith(lastArgument) && !absolutePath.startsWith(lastArgument)) continue;
                    candidates.add(displayPath);
                }
                Collections.sort(candidates, new Comparator<CharSequence>(){

                    @Override
                    public int compare(CharSequence thisPath, CharSequence thatPath) {
                        return thisPath.toString().compareTo(thatPath.toString());
                    }
                });
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

