/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.tabularresultset;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.tabularresultset.TabularResultSetCommandsI18n;
import org.komodo.relational.commands.tabularresultset.TabularResultSetShellCommand;
import org.komodo.relational.model.ResultSetColumn;
import org.komodo.relational.model.TabularResultSet;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddColumnCommand
extends TabularResultSetShellCommand {
    static final String NAME = "add-column";

    public AddColumnCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            ResultSetColumn[] cols;
            String columnName = this.requiredArgument(0, I18n.bind((String)TabularResultSetCommandsI18n.missingColumnName, (Object[])new Object[0]));
            TabularResultSet resultSet = this.getTabularResultSet();
            for (ResultSetColumn col : cols = resultSet.getColumns(this.getTransaction())) {
                if (!columnName.equals(col.getName(this.getTransaction()))) continue;
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{columnName, ResultSetColumn.class.getSimpleName()}), null);
            }
            resultSet.addColumn(this.getTransaction(), columnName);
            result = new CommandResultImpl(I18n.bind((String)TabularResultSetCommandsI18n.columnAdded, (Object[])new Object[]{columnName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)TabularResultSetCommandsI18n.addColumnHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)TabularResultSetCommandsI18n.addColumnExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)TabularResultSetCommandsI18n.addColumnUsage, (Object[])new Object[0]), new Object[0]);
    }
}

